"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
exports.__esModule = true;
exports.NotColumn = exports.EnumColumn = exports.IntColumn = exports.StringColumn = exports.OptionalValidate = exports.MergePropertyDecorators = void 0;
var typeorm_1 = require("typeorm");
var swagger_1 = require("@nestjs/swagger");
var class_validator_1 = require("class-validator");
var bigint_transform_1 = require("../utility/bigint-transform");
var class_transformer_1 = require("class-transformer");
function MergePropertyDecorators(decs) {
    return function (obj, key) {
        for (var _i = 0, decs_1 = decs; _i < decs_1.length; _i++) {
            var dec = decs_1[_i];
            dec(obj, key);
        }
    };
}
exports.MergePropertyDecorators = MergePropertyDecorators;
var OptionalValidate = function () {
    var conitions = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        conitions[_i] = arguments[_i];
    }
    return MergePropertyDecorators(__spreadArray([(0, class_validator_1.IsOptional)()], conitions, true));
};
exports.OptionalValidate = OptionalValidate;
var StringColumn = function (length, description, defaultValue, required, columnExtras, propertyExtras) {
    if (length === void 0) { length = 32; }
    if (description === void 0) { description = 'unknown'; }
    if (required === void 0) { required = false; }
    if (columnExtras === void 0) { columnExtras = {}; }
    if (propertyExtras === void 0) { propertyExtras = {}; }
    return MergePropertyDecorators(__spreadArray(__spreadArray([
        (0, typeorm_1.Column)('varchar', __assign({ length: length, "default": defaultValue, nullable: !required && defaultValue == null, comment: description }, columnExtras)),
        (0, swagger_1.ApiProperty)(__assign({ type: String, description: description, "default": defaultValue, required: required && defaultValue == null, maxLength: length }, propertyExtras))
    ], (required ? [] : [(0, class_validator_1.IsOptional)()]), true), [
        (0, class_validator_1.IsString)(),
        (0, class_validator_1.IsNotEmpty)(),
        (0, class_validator_1.MaxLength)(length),
    ], false));
};
exports.StringColumn = StringColumn;
var IntColumn = function (type, unsigned, description, defaultValue, required, columnExtras, propertyExtras) {
    if (type === void 0) { type = 'int'; }
    if (unsigned === void 0) { unsigned = false; }
    if (description === void 0) { description = 'unknown'; }
    if (required === void 0) { required = false; }
    if (columnExtras === void 0) { columnExtras = {}; }
    if (propertyExtras === void 0) { propertyExtras = {}; }
    return MergePropertyDecorators(__spreadArray(__spreadArray(__spreadArray([
        (0, typeorm_1.Column)(type, __assign(__assign({ "default": defaultValue, nullable: !required && defaultValue == null, unsigned: unsigned, comment: description }, (type === 'bigint' ? { transformer: new bigint_transform_1.BigintTransformer() } : {})), columnExtras)),
        (0, swagger_1.ApiProperty)(__assign({ type: Number, description: description, "default": defaultValue, required: required && defaultValue == null }, propertyExtras))
    ], (required ? [] : [(0, class_validator_1.IsOptional)()]), true), [
        (0, class_validator_1.IsInt)()
    ], false), (unsigned ? [(0, class_validator_1.Min)(0)] : []), true));
};
exports.IntColumn = IntColumn;
var EnumColumn = function (targetEnum, description, defaultValue, required, columnExtras, swaggerExtras) {
    if (description === void 0) { description = 'unknown'; }
    if (required === void 0) { required = false; }
    if (columnExtras === void 0) { columnExtras = {}; }
    if (swaggerExtras === void 0) { swaggerExtras = {}; }
    return MergePropertyDecorators(__spreadArray(__spreadArray([
        (0, typeorm_1.Index)(),
        (0, typeorm_1.Column)('enum', __assign({ "enum": targetEnum, "default": defaultValue, nullable: !required && !defaultValue, comment: description }, columnExtras)),
        (0, swagger_1.ApiProperty)(__assign({ description: description, "enum": targetEnum, "default": defaultValue, required: required }, swaggerExtras))
    ], (required ? [] : [(0, class_validator_1.IsOptional)()]), true), [
        (0, class_validator_1.IsEnum)(targetEnum),
    ], false));
};
exports.EnumColumn = EnumColumn;
var NotColumn = function (description, swaggerExtras) {
    if (swaggerExtras === void 0) { swaggerExtras = {}; }
    return MergePropertyDecorators([
        (0, class_transformer_1.Exclude)(),
        (0, swagger_1.ApiProperty)(__assign({ description: description, required: false, readOnly: true }, swaggerExtras)),
    ]);
};
exports.NotColumn = NotColumn;
