import { StringColumn } from '../decorators/base';
import { SelectQueryBuilder } from 'typeorm';
import { applyQueryProperty } from '../utility/query';
import { ManualNameDescBase } from './ManualNameDescBase.entity';

export class AvatarBase extends ManualNameDescBase {
  @StringColumn(128, '图标地址', undefined, false)
  avatarUrl: string;

  override applyQuery(qb: SelectQueryBuilder<AvatarBase>, entityName: string) {
    super.applyQuery(qb, entityName);
    applyQueryProperty(this, qb, entityName, 'avatarUrl');
  }
}
