"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
exports.__esModule = true;
exports.IdBase = void 0;
var openapi = require("@nestjs/swagger");
var typeorm_1 = require("typeorm");
var swagger_1 = require("@nestjs/swagger");
var query_1 = require("../utility/query");
var transform_1 = require("../decorators/transform");
var class_validator_1 = require("class-validator");
var bigint_transform_1 = require("../utility/bigint-transform");
var TimeBase_entity_1 = require("./TimeBase.entity");
var IdBase = /** @class */ (function (_super) {
    __extends(IdBase, _super);
    function IdBase() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    IdBase.prototype.applyQuery = function (qb, entityName) {
        _super.prototype.applyQuery.call(this, qb, entityName);
        qb.orderBy("".concat(entityName, ".id"), 'DESC');
        (0, query_1.applyQueryProperty)(this, qb, entityName, 'id');
    };
    IdBase._OPENAPI_METADATA_FACTORY = function () {
        return { id: { required: true, type: function () { return Number; }, minimum: 1 } };
    };
    __decorate([
        (0, typeorm_1.Generated)('increment'),
        (0, typeorm_1.Column)('bigint', {
            primary: true,
            unsigned: true,
            transformer: new bigint_transform_1.BigintTransformer()
        }),
        (0, swagger_1.ApiProperty)({ description: '编号', required: false }),
        (0, transform_1.NotWritable)(),
        (0, class_validator_1.IsInt)(),
        (0, class_validator_1.IsPositive)()
    ], IdBase.prototype, "id");
    return IdBase;
}(TimeBase_entity_1.TimeBase));
exports.IdBase = IdBase;
