"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
exports.__esModule = true;
exports.StringReturnMessageDto = exports.PaginatedReturnMessageDto = exports.ReturnMessageDto = exports.BlankPaginatedReturnMessageDto = exports.BlankReturnMessageDto = void 0;
var openapi = require("@nestjs/swagger");
var swagger_1 = require("@nestjs/swagger");
var common_1 = require("@nestjs/common");
var BlankReturnMessageDto = /** @class */ (function () {
    function BlankReturnMessageDto(statusCode, message) {
        this.statusCode = statusCode;
        this.message = message || 'success';
        this.success = statusCode < 400;
    }
    BlankReturnMessageDto.prototype.toException = function () {
        return new common_1.HttpException(this, this.statusCode);
    };
    BlankReturnMessageDto._OPENAPI_METADATA_FACTORY = function () {
        return { statusCode: { required: true, type: function () { return Number; } }, message: { required: true, type: function () { return String; } }, success: { required: true, type: function () { return Boolean; } } };
    };
    __decorate([
        (0, swagger_1.ApiProperty)({ description: '返回状态' })
    ], BlankReturnMessageDto.prototype, "statusCode");
    __decorate([
        (0, swagger_1.ApiProperty)({ description: '返回信息' })
    ], BlankReturnMessageDto.prototype, "message");
    __decorate([
        (0, swagger_1.ApiProperty)({ description: '是否成功' })
    ], BlankReturnMessageDto.prototype, "success");
    return BlankReturnMessageDto;
}());
exports.BlankReturnMessageDto = BlankReturnMessageDto;
var BlankPaginatedReturnMessageDto = /** @class */ (function (_super) {
    __extends(BlankPaginatedReturnMessageDto, _super);
    function BlankPaginatedReturnMessageDto(statusCode, message, total, pageSettings) {
        var _this = _super.call(this, statusCode, message) || this;
        _this.total = total;
        _this.pageCount = pageSettings.pageCount;
        _this.recordsPerPage = pageSettings.recordsPerPage;
        _this.totalPages = Math.ceil(total / pageSettings.recordsPerPage);
        return _this;
    }
    BlankPaginatedReturnMessageDto._OPENAPI_METADATA_FACTORY = function () {
        return { total: { required: true, type: function () { return Number; } }, totalPages: { required: true, type: function () { return Number; } }, pageCount: { required: true, type: function () { return Number; } }, recordsPerPage: { required: true, type: function () { return Number; } } };
    };
    __decorate([
        (0, swagger_1.ApiProperty)({ description: '总数' })
    ], BlankPaginatedReturnMessageDto.prototype, "total");
    __decorate([
        (0, swagger_1.ApiProperty)({ description: '总页数' })
    ], BlankPaginatedReturnMessageDto.prototype, "totalPages");
    __decorate([
        (0, swagger_1.ApiProperty)({ description: '当前页' })
    ], BlankPaginatedReturnMessageDto.prototype, "pageCount");
    __decorate([
        (0, swagger_1.ApiProperty)({ description: '每页数量' })
    ], BlankPaginatedReturnMessageDto.prototype, "recordsPerPage");
    return BlankPaginatedReturnMessageDto;
}(BlankReturnMessageDto));
exports.BlankPaginatedReturnMessageDto = BlankPaginatedReturnMessageDto;
var ReturnMessageDto = /** @class */ (function (_super) {
    __extends(ReturnMessageDto, _super);
    function ReturnMessageDto(statusCode, message, data) {
        var _this = _super.call(this, statusCode, message) || this;
        _this.data = data;
        return _this;
    }
    ReturnMessageDto._OPENAPI_METADATA_FACTORY = function () {
        return { data: { required: false } };
    };
    __decorate([
        (0, swagger_1.ApiProperty)({ description: '返回内容' })
    ], ReturnMessageDto.prototype, "data");
    return ReturnMessageDto;
}(BlankReturnMessageDto));
exports.ReturnMessageDto = ReturnMessageDto;
var PaginatedReturnMessageDto = /** @class */ (function (_super) {
    __extends(PaginatedReturnMessageDto, _super);
    function PaginatedReturnMessageDto(statusCode, message, data, total, pageSettings) {
        var _this = _super.call(this, statusCode, message, total, pageSettings) || this;
        _this.data = data;
        return _this;
    }
    PaginatedReturnMessageDto._OPENAPI_METADATA_FACTORY = function () {
        return { data: { required: true } };
    };
    __decorate([
        (0, swagger_1.ApiProperty)({ description: '返回内容' })
    ], PaginatedReturnMessageDto.prototype, "data");
    return PaginatedReturnMessageDto;
}(BlankPaginatedReturnMessageDto));
exports.PaginatedReturnMessageDto = PaginatedReturnMessageDto;
var StringReturnMessageDto = /** @class */ (function (_super) {
    __extends(StringReturnMessageDto, _super);
    function StringReturnMessageDto() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    StringReturnMessageDto._OPENAPI_METADATA_FACTORY = function () {
        return { data: { required: false, type: function () { return String; } } };
    };
    __decorate([
        (0, swagger_1.ApiProperty)({ description: '返回内容' })
    ], StringReturnMessageDto.prototype, "data");
    return StringReturnMessageDto;
}(BlankReturnMessageDto));
exports.StringReturnMessageDto = StringReturnMessageDto;
