"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
exports.__esModule = true;
exports.PageSettingsDto = void 0;
var openapi = require("@nestjs/swagger");
var class_validator_1 = require("class-validator");
var swagger_1 = require("@nestjs/swagger");
var transform_1 = require("../entities/decorators/transform");
var PageSettingsDto = /** @class */ (function () {
    function PageSettingsDto() {
    }
    PageSettingsDto.prototype.getActualPageSettings = function () {
        return {
            pageCount: this.getPageCount(),
            recordsPerPage: this.getRecordsPerPage()
        };
    };
    PageSettingsDto.prototype.getPageCount = function () {
        return this.pageCount || 1;
    };
    PageSettingsDto.prototype.getRecordsPerPage = function () {
        return this.recordsPerPage || 25;
    };
    PageSettingsDto.prototype.getStartingFrom = function () {
        return (this.getPageCount() - 1) * this.getRecordsPerPage();
    };
    PageSettingsDto.prototype.applyQuery = function (qb, entityName) {
        qb.take(this.getRecordsPerPage()).skip(this.getStartingFrom());
    };
    PageSettingsDto._OPENAPI_METADATA_FACTORY = function () {
        return { pageCount: { required: true, type: function () { return Number; }, minimum: 1 }, recordsPerPage: { required: true, type: function () { return Number; }, minimum: 1 } };
    };
    __decorate([
        (0, transform_1.NotWritable)(),
        (0, class_validator_1.IsPositive)(),
        (0, class_validator_1.IsInt)(),
        (0, swagger_1.ApiProperty)({ description: '第 n 页，从 1 开始', required: false })
    ], PageSettingsDto.prototype, "pageCount");
    __decorate([
        (0, transform_1.NotWritable)(),
        (0, class_validator_1.IsPositive)(),
        (0, class_validator_1.IsInt)(),
        (0, swagger_1.ApiProperty)({ description: '每页显示的数量', required: false })
    ], PageSettingsDto.prototype, "recordsPerPage");
    return PageSettingsDto;
}());
exports.PageSettingsDto = PageSettingsDto;
