"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
exports.__esModule = true;
exports.CrudFactory = exports.MergeMethodDecorators = void 0;
var swagger_1 = require("@nestjs/swagger");
var common_1 = require("@nestjs/common");
var ReturnMessage_dto_1 = require("../dto/ReturnMessage.dto");
var TimeBase_entity_1 = require("../entities/bases/TimeBase.entity");
var pipes_1 = require("../utility/pipes");
function MergeMethodDecorators(decorators) {
    return function (target, key, descriptor) {
        decorators.forEach(function (decorator) {
            decorator(target, key, descriptor);
        });
    };
}
exports.MergeMethodDecorators = MergeMethodDecorators;
var CrudFactory = /** @class */ (function () {
    function CrudFactory(entityClass, fieldsToOmit, 
    // eslint-disable-next-line @typescript-eslint/ban-types
    idType) {
        if (fieldsToOmit === void 0) { fieldsToOmit = []; }
        if (idType === void 0) { idType = Number; }
        this.entityClass = entityClass;
        this.idType = idType;
        this.createDto = (0, swagger_1.OmitType)(this.entityClass, __spreadArray(__spreadArray([], TimeBase_entity_1.TimeBaseFields, true), fieldsToOmit, true));
        this.updateDto = (0, swagger_1.PartialType)(this.createDto);
        this.entityReturnMessageDto = /** @class */ (function (_super) {
            __extends(EntityReturnMessageDto, _super);
            function EntityReturnMessageDto() {
                return _super !== null && _super.apply(this, arguments) || this;
            }
            return EntityReturnMessageDto;
        }((ReturnMessage_dto_1.BlankReturnMessageDto)));
        (0, swagger_1.ApiProperty)({ type: this.entityClass })(this.entityReturnMessageDto.prototype, 'data');
        this.entityArrayReturnMessageDto = /** @class */ (function (_super) {
            __extends(EntityArrayReturnMessageDto, _super);
            function EntityArrayReturnMessageDto() {
                return _super !== null && _super.apply(this, arguments) || this;
            }
            return EntityArrayReturnMessageDto;
        }((ReturnMessage_dto_1.BlankPaginatedReturnMessageDto)));
        (0, swagger_1.ApiProperty)({ type: [this.entityClass] })(this.entityArrayReturnMessageDto.prototype, 'data');
    }
    CrudFactory.prototype.create = function () {
        return MergeMethodDecorators([
            (0, common_1.Post)(),
            (0, swagger_1.ApiOperation)({ summary: "Create a new ".concat(this.entityClass.name) }),
            (0, swagger_1.ApiBody)({ type: this.createDto }),
            (0, swagger_1.ApiCreatedResponse)({ type: this.entityReturnMessageDto }),
        ]);
    };
    CrudFactory.prototype.createParam = function () {
        return (0, common_1.Body)(pipes_1.CreatePipe);
    };
    CrudFactory.prototype.findOne = function () {
        return MergeMethodDecorators([
            (0, common_1.Get)(':id'),
            (0, swagger_1.ApiOperation)({ summary: "Find a ".concat(this.entityClass.name, " by id") }),
            (0, swagger_1.ApiParam)({ name: 'id', type: this.idType, required: true }),
            (0, swagger_1.ApiOkResponse)({ type: this.entityReturnMessageDto }),
        ]);
    };
    CrudFactory.prototype.findAll = function () {
        return MergeMethodDecorators([
            (0, common_1.Get)(),
            (0, swagger_1.ApiOperation)({ summary: "Find all ".concat(this.entityClass.name) }),
            (0, swagger_1.ApiOkResponse)({ type: this.entityArrayReturnMessageDto }),
        ]);
    };
    CrudFactory.prototype.findAllParam = function () {
        return (0, common_1.Query)(new pipes_1.ClassGetPipe(this.entityClass));
    };
    CrudFactory.prototype.update = function () {
        return MergeMethodDecorators([
            (0, common_1.Patch)(':id'),
            (0, swagger_1.ApiOperation)({ summary: "Update a ".concat(this.entityClass.name, " by id") }),
            (0, swagger_1.ApiParam)({ name: 'id', type: this.idType, required: true }),
            (0, swagger_1.ApiBody)({ type: this.updateDto }),
            (0, swagger_1.ApiOkResponse)({ type: ReturnMessage_dto_1.BlankReturnMessageDto }),
        ]);
    };
    CrudFactory.prototype.updateParam = function () {
        return (0, common_1.Body)(pipes_1.UpdatePipe);
    };
    CrudFactory.prototype["delete"] = function () {
        return MergeMethodDecorators([
            (0, common_1.Delete)(':id'),
            (0, swagger_1.ApiOperation)({ summary: "Delete a ".concat(this.entityClass.name, " by id") }),
            (0, swagger_1.ApiParam)({ name: 'id', type: this.idType, required: true }),
            (0, swagger_1.ApiNoContentResponse)({ type: ReturnMessage_dto_1.BlankReturnMessageDto }),
        ]);
    };
    return CrudFactory;
}());
exports.CrudFactory = CrudFactory;
