"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
exports.__esModule = true;
exports.CrudBase = exports.Inner = void 0;
var common_1 = require("@nestjs/common");
var typeorm_1 = require("typeorm");
var ReturnMessage_dto_1 = require("../dto/ReturnMessage.dto");
var StringUtils_1 = require("typeorm/util/StringUtils");
var lodash_1 = require("lodash");
var Inner = function (name) {
    return { name: name, inner: true };
};
exports.Inner = Inner;
var CrudBase = /** @class */ (function (_super) {
    __extends(CrudBase, _super);
    function CrudBase(entityClass, repo, entityRelations, 
    // eslint-disable-next-line @typescript-eslint/no-empty-function
    extraGetQuery) {
        if (entityRelations === void 0) { entityRelations = []; }
        if (extraGetQuery === void 0) { extraGetQuery = function (qb) { }; }
        var _this = _super.call(this, "".concat(entityClass.name, " Service")) || this;
        _this.entityClass = entityClass;
        _this.repo = repo;
        _this.entityRelations = entityRelations;
        _this.extraGetQuery = extraGetQuery;
        _this.entityName = entityClass.name;
        return _this;
    }
    CrudBase.prototype.batchCreate = function (ents, beforeCreate, skipErrors) {
        if (skipErrors === void 0) { skipErrors = false; }
        return __awaiter(this, void 0, void 0, function () {
            var entsWithId, result;
            var _this = this;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        entsWithId = ents.filter(function (ent) { return ent.id != null; });
                        return [4 /*yield*/, this.repo.manager.transaction(function (mdb) { return __awaiter(_this, void 0, void 0, function () {
                                var skipped, repo, existingEnts, existingEntsWithoutDeleteTime_1, existingEntsWithDeleteTime, skippedEnts, skippedEntsSet_1, results, e_1;
                                return __generator(this, function (_a) {
                                    switch (_a.label) {
                                        case 0:
                                            skipped = [];
                                            repo = mdb.getRepository(this.entityClass);
                                            if (!entsWithId.length) return [3 /*break*/, 3];
                                            return [4 /*yield*/, repo.find({
                                                    where: { id: (0, typeorm_1.In)(entsWithId.map(function (ent) { return ent.id; })) },
                                                    select: ['id', 'deleteTime'],
                                                    withDeleted: true
                                                })];
                                        case 1:
                                            existingEnts = _a.sent();
                                            if (!existingEnts.length) return [3 /*break*/, 3];
                                            existingEntsWithoutDeleteTime_1 = existingEnts.filter(function (ent) { return ent.deleteTime == null; });
                                            existingEntsWithDeleteTime = existingEnts.filter(function (ent) { return ent.deleteTime != null; });
                                            if (existingEntsWithoutDeleteTime_1.length) {
                                                if (!skipErrors) {
                                                    throw new ReturnMessage_dto_1.BlankReturnMessageDto(404, "".concat(this.entityName, " ID ").concat(existingEntsWithoutDeleteTime_1.join(','), " already exists")).toException();
                                                }
                                                skippedEnts = ents.filter(function (ent) {
                                                    return existingEntsWithoutDeleteTime_1.some(function (e) { return e.id === ent.id; });
                                                });
                                                skipped = skippedEnts.map(function (ent) { return ({
                                                    result: 'Already exists',
                                                    entry: ent
                                                }); });
                                                skippedEntsSet_1 = new Set(skippedEnts);
                                                ents = ents.filter(function (ent) { return !skippedEntsSet_1.has(ent); });
                                            }
                                            if (!existingEntsWithDeleteTime.length) return [3 /*break*/, 3];
                                            return [4 /*yield*/, repo["delete"](existingEntsWithDeleteTime.map(function (ent) { return ent.id; }))];
                                        case 2:
                                            _a.sent();
                                            _a.label = 3;
                                        case 3:
                                            if (!beforeCreate) return [3 /*break*/, 5];
                                            return [4 /*yield*/, beforeCreate(repo)];
                                        case 4:
                                            _a.sent();
                                            _a.label = 5;
                                        case 5:
                                            _a.trys.push([5, 7, , 8]);
                                            return [4 /*yield*/, repo.save(ents)];
                                        case 6:
                                            results = _a.sent();
                                            return [2 /*return*/, {
                                                    results: results,
                                                    skipped: skipped
                                                }];
                                        case 7:
                                            e_1 = _a.sent();
                                            this.error("Failed to create entity ".concat(JSON.stringify(ents), ": ").concat(e_1.toString()));
                                            throw new ReturnMessage_dto_1.BlankReturnMessageDto(500, 'internal error').toException();
                                        case 8: return [2 /*return*/];
                                    }
                                });
                            }); })];
                    case 1:
                        result = _a.sent();
                        return [2 /*return*/, new ReturnMessage_dto_1.ReturnMessageDto(201, 'success', result)];
                }
            });
        });
    };
    CrudBase.prototype.create = function (ent, beforeCreate) {
        return __awaiter(this, void 0, void 0, function () {
            var savedEnt;
            var _this = this;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this.repo.manager.transaction(function (mdb) { return __awaiter(_this, void 0, void 0, function () {
                            var repo, existingEnt, e_2;
                            return __generator(this, function (_a) {
                                switch (_a.label) {
                                    case 0:
                                        repo = mdb.getRepository(this.entityClass);
                                        if (!(ent.id != null)) return [3 /*break*/, 4];
                                        return [4 /*yield*/, repo.findOne({
                                                where: { id: ent.id },
                                                select: ['id', 'deleteTime'],
                                                withDeleted: true
                                            })];
                                    case 1:
                                        existingEnt = _a.sent();
                                        if (!existingEnt) return [3 /*break*/, 4];
                                        if (!existingEnt.deleteTime) return [3 /*break*/, 3];
                                        return [4 /*yield*/, repo["delete"](existingEnt.id)];
                                    case 2:
                                        _a.sent();
                                        return [3 /*break*/, 4];
                                    case 3: throw new ReturnMessage_dto_1.BlankReturnMessageDto(404, "".concat(this.entityName, " ID ").concat(ent.id, " already exists")).toException();
                                    case 4:
                                        if (!beforeCreate) return [3 /*break*/, 6];
                                        return [4 /*yield*/, beforeCreate(repo)];
                                    case 5:
                                        _a.sent();
                                        _a.label = 6;
                                    case 6:
                                        _a.trys.push([6, 8, , 9]);
                                        return [4 /*yield*/, repo.save(ent)];
                                    case 7: return [2 /*return*/, _a.sent()];
                                    case 8:
                                        e_2 = _a.sent();
                                        this.error("Failed to create entity ".concat(JSON.stringify(ent), ": ").concat(e_2.toString()));
                                        throw new ReturnMessage_dto_1.BlankReturnMessageDto(500, 'internal error').toException();
                                    case 9: return [2 /*return*/];
                                }
                            });
                        }); })];
                    case 1:
                        savedEnt = _a.sent();
                        return [2 /*return*/, new ReturnMessage_dto_1.ReturnMessageDto(201, 'success', savedEnt)];
                }
            });
        });
    };
    Object.defineProperty(CrudBase.prototype, "entityAliasName", {
        get: function () {
            return (0, StringUtils_1.camelCase)(this.entityName);
        },
        enumerable: false,
        configurable: true
    });
    CrudBase.prototype.applyRelationToQuery = function (qb, relation) {
        var name = relation.name;
        var relationUnit = name.split('.');
        var base = relationUnit.length === 1
            ? this.entityAliasName
            : relationUnit.slice(0, relationUnit.length - 1).join('_');
        var property = relationUnit[relationUnit.length - 1];
        var properyAlias = relationUnit.join('_');
        var methodName = relation.inner
            ? 'innerJoinAndSelect'
            : 'leftJoinAndSelect';
        qb[methodName]("".concat(base, ".").concat(property), properyAlias);
    };
    CrudBase.prototype.applyRelationsToQuery = function (qb) {
        for (var _i = 0, _a = this.entityRelations; _i < _a.length; _i++) {
            var relation = _a[_i];
            if (typeof relation === 'string') {
                this.applyRelationToQuery(qb, { name: relation });
            }
            else {
                this.applyRelationToQuery(qb, relation);
            }
        }
    };
    CrudBase.prototype.queryBuilder = function () {
        return this.repo.createQueryBuilder(this.entityAliasName);
    };
    CrudBase.prototype.findOne = function (id, extraQuery) {
        if (extraQuery === void 0) { extraQuery = function () { }; }
        return __awaiter(this, void 0, void 0, function () {
            var query, ent, e_3, _a, sql, params;
            return __generator(this, function (_b) {
                switch (_b.label) {
                    case 0:
                        query = this.queryBuilder()
                            .where("".concat(this.entityAliasName, ".id = :id"), { id: id })
                            .take(1);
                        this.applyRelationsToQuery(query);
                        this.extraGetQuery(query);
                        extraQuery(query);
                        query.take(1);
                        _b.label = 1;
                    case 1:
                        _b.trys.push([1, 3, , 4]);
                        return [4 /*yield*/, query.getOne()];
                    case 2:
                        ent = _b.sent();
                        return [3 /*break*/, 4];
                    case 3:
                        e_3 = _b.sent();
                        _a = query.getQueryAndParameters(), sql = _a[0], params = _a[1];
                        this.error("Failed to read entity ID ".concat(id, " with SQL ").concat(sql, " param ").concat(params.join(','), ": ").concat(e_3.toString()));
                        throw new ReturnMessage_dto_1.BlankReturnMessageDto(500, 'internal error').toException();
                    case 4:
                        if (!ent) {
                            throw new ReturnMessage_dto_1.BlankReturnMessageDto(404, "".concat(this.entityName, " ID ").concat(id, " not found.")).toException();
                        }
                        return [2 /*return*/, new ReturnMessage_dto_1.ReturnMessageDto(200, 'success', ent)];
                }
            });
        });
    };
    CrudBase.prototype.findAll = function (ent, extraQuery) {
        if (extraQuery === void 0) { extraQuery = function () { }; }
        return __awaiter(this, void 0, void 0, function () {
            var query, _a, ents, count, e_4, _b, sql, params;
            return __generator(this, function (_c) {
                switch (_c.label) {
                    case 0:
                        query = this.queryBuilder();
                        if (ent) {
                            ent.applyQuery(query, this.entityAliasName);
                        }
                        this.applyRelationsToQuery(query);
                        this.extraGetQuery(query);
                        extraQuery(query);
                        _c.label = 1;
                    case 1:
                        _c.trys.push([1, 3, , 4]);
                        return [4 /*yield*/, query.getManyAndCount()];
                    case 2:
                        _a = _c.sent(), ents = _a[0], count = _a[1];
                        return [2 /*return*/, new ReturnMessage_dto_1.PaginatedReturnMessageDto(200, 'success', ents, count, ent.getActualPageSettings())];
                    case 3:
                        e_4 = _c.sent();
                        _b = query.getQueryAndParameters(), sql = _b[0], params = _b[1];
                        this.error("Failed to read entity cond ".concat(JSON.stringify(ent), " with SQL ").concat(sql, " param ").concat(params.join(','), ": ").concat(e_4.toString()));
                        throw new ReturnMessage_dto_1.BlankReturnMessageDto(500, 'internal error').toException();
                    case 4: return [2 /*return*/];
                }
            });
        });
    };
    CrudBase.prototype.update = function (id, entPart, cond) {
        if (cond === void 0) { cond = {}; }
        return __awaiter(this, void 0, void 0, function () {
            var result, e_5;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        _a.trys.push([0, 2, , 3]);
                        return [4 /*yield*/, this.repo.update(__assign({ id: id }, cond), entPart)];
                    case 1:
                        result = _a.sent();
                        return [3 /*break*/, 3];
                    case 2:
                        e_5 = _a.sent();
                        this.error("Failed to update entity ID ".concat(id, " to ").concat(JSON.stringify(entPart), ": ").concat(e_5.toString()));
                        throw new ReturnMessage_dto_1.BlankReturnMessageDto(500, 'internal error').toException();
                    case 3:
                        if (!result.affected) {
                            throw new ReturnMessage_dto_1.BlankReturnMessageDto(404, "".concat(this.entityName, " ID ").concat(id, " not found.")).toException();
                        }
                        return [2 /*return*/, new ReturnMessage_dto_1.BlankReturnMessageDto(200, 'success')];
                }
            });
        });
    };
    CrudBase.prototype.remove = function (id, hardDelete, cond) {
        if (hardDelete === void 0) { hardDelete = false; }
        if (cond === void 0) { cond = {}; }
        return __awaiter(this, void 0, void 0, function () {
            var result, searchCond, e_6;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        searchCond = __assign({ id: id }, cond);
                        _a.label = 1;
                    case 1:
                        _a.trys.push([1, 3, , 4]);
                        return [4 /*yield*/, (hardDelete
                                ? this.repo["delete"](searchCond)
                                : this.repo.softDelete(searchCond))];
                    case 2:
                        result = _a.sent();
                        return [3 /*break*/, 4];
                    case 3:
                        e_6 = _a.sent();
                        this.error("Failed to delete entity ID ".concat(id, ": ").concat(e_6.toString()));
                        throw new ReturnMessage_dto_1.BlankReturnMessageDto(500, 'internal error').toException();
                    case 4:
                        if (!result.affected) {
                            throw new ReturnMessage_dto_1.BlankReturnMessageDto(404, "".concat(this.entityName, " ID ").concat(id, " not found.")).toException();
                        }
                        return [2 /*return*/, new ReturnMessage_dto_1.BlankReturnMessageDto(204, 'success')];
                }
            });
        });
    };
    CrudBase.prototype.importEntities = function (ents, extraChecking) {
        return __awaiter(this, void 0, void 0, function () {
            var invalidResults, _a, _b, remainingEnts, data, results;
            var _this = this;
            return __generator(this, function (_c) {
                switch (_c.label) {
                    case 0:
                        _b = (_a = lodash_1["default"]).compact;
                        return [4 /*yield*/, Promise.all(ents.map(function (ent) { return __awaiter(_this, void 0, void 0, function () {
                                var reason, reason_1;
                                return __generator(this, function (_a) {
                                    switch (_a.label) {
                                        case 0:
                                            reason = ent.isValidInCreation();
                                            if (reason) {
                                                return [2 /*return*/, { entry: ent, result: reason }];
                                            }
                                            if (!extraChecking) return [3 /*break*/, 2];
                                            return [4 /*yield*/, extraChecking(ent)];
                                        case 1:
                                            reason_1 = _a.sent();
                                            if (reason_1) {
                                                return [2 /*return*/, { entry: ent, result: reason_1 }];
                                            }
                                            _a.label = 2;
                                        case 2: return [2 /*return*/];
                                    }
                                });
                            }); }))];
                    case 1:
                        invalidResults = _b.apply(_a, [_c.sent()]);
                        remainingEnts = ents.filter(function (ent) { return !invalidResults.find(function (result) { return result.entry === ent; }); });
                        return [4 /*yield*/, Promise.all(remainingEnts.map(function (ent) { return ent.prepareForSaving(); }))];
                    case 2:
                        _c.sent();
                        return [4 /*yield*/, this.batchCreate(remainingEnts, undefined, true)];
                    case 3:
                        data = (_c.sent()).data;
                        data.results.forEach(function (e) {
                            if (e.afterSaving) {
                                e.afterSaving();
                            }
                        });
                        results = __spreadArray(__spreadArray(__spreadArray([], invalidResults, true), data.skipped, true), data.results.map(function (e) { return ({ entry: e, result: 'OK' }); }), true);
                        return [2 /*return*/, new ReturnMessage_dto_1.ReturnMessageDto(201, 'success', results)];
                }
            });
        });
    };
    CrudBase.prototype.exists = function (id) {
        return __awaiter(this, void 0, void 0, function () {
            var ent;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this.repo.findOne({ where: { id: id }, select: ['id'] })];
                    case 1:
                        ent = _a.sent();
                        return [2 /*return*/, !!ent];
                }
            });
        });
    };
    return CrudBase;
}(common_1.ConsoleLogger));
exports.CrudBase = CrudBase;
