import { Module } from '@nestjs/common';
import { TypeOrmModule } from '@nestjs/typeorm';
import { ConfigModule, ConfigService } from '@nestjs/config';
import { KoishiModule, PluginDef } from 'koishi-nestjs';
import OneBot from '@koishijs/plugin-adapter-onebot';
import { RankRecord } from './entities/rank-record.entity';
import { RecordService } from './record/record.service';
import { CommandService } from './command/command.service';

@Module({
  imports: [
    ConfigModule.forRoot({
      isGlobal: true,
    }),
    TypeOrmModule.forRootAsync({
      inject: [ConfigService],
      useFactory: async (config: ConfigService) => {
        return {
          type: 'postgres',
          autoLoadEntities: true,
          synchronize: !config.get('DB_NO_INIT'),
          host: config.get('DB_HOST'),
          port: parseInt(config.get('DB_PORT')) || 5432,
          username: config.get('DB_USER'),
          password: config.get('DB_PASS'),
          database: config.get('DB_NAME'),
          supportBigNumbers: true,
          bigNumberStrings: false,
        };
      },
    }),
    TypeOrmModule.forFeature([RankRecord]),
    KoishiModule.registerAsync({
      inject: [ConfigService],
      useFactory: async (config: ConfigService) => {
        return {
          prefix: '.',
          actionErrorMessage: '',
          usePlugins: [
            PluginDef(OneBot, {
              protocol: 'ws',
              endpoint: config.get('ONEBOT_HOST'),
              token: config.get('ONEBOT_TOKEN'),
              selfId: config.get('ONEBOT_ID'),
            }),
          ],
        };
      },
    }),
  ],
  providers: [RecordService, CommandService],
})
export class AppModule {}
