"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
exports.__esModule = true;
exports.AppModule = void 0;
var common_1 = require("@nestjs/common");
var typeorm_1 = require("@nestjs/typeorm");
var config_1 = require("@nestjs/config");
var koishi_nestjs_1 = require("koishi-nestjs");
var plugin_adapter_onebot_1 = require("@koishijs/plugin-adapter-onebot");
var rank_record_entity_1 = require("./entities/rank-record.entity");
var record_service_1 = require("./record/record.service");
var command_service_1 = require("./command/command.service");
var AppModule = /** @class */ (function () {
    function AppModule() {
    }
    AppModule = __decorate([
        (0, common_1.Module)({
            imports: [
                config_1.ConfigModule.forRoot({
                    isGlobal: true
                }),
                typeorm_1.TypeOrmModule.forRootAsync({
                    inject: [config_1.ConfigService],
                    useFactory: function (config) { return __awaiter(void 0, void 0, void 0, function () {
                        return __generator(this, function (_a) {
                            return [2 /*return*/, {
                                    type: 'postgres',
                                    autoLoadEntities: true,
                                    synchronize: !config.get('DB_NO_INIT'),
                                    host: config.get('DB_HOST'),
                                    port: parseInt(config.get('DB_PORT')) || 5432,
                                    username: config.get('DB_USER'),
                                    password: config.get('DB_PASS'),
                                    database: config.get('DB_NAME'),
                                    supportBigNumbers: true,
                                    bigNumberStrings: false
                                }];
                        });
                    }); }
                }),
                typeorm_1.TypeOrmModule.forFeature([rank_record_entity_1.RankRecord]),
                koishi_nestjs_1.KoishiModule.registerAsync({
                    inject: [config_1.ConfigService],
                    useFactory: function (config) { return __awaiter(void 0, void 0, void 0, function () {
                        return __generator(this, function (_a) {
                            return [2 /*return*/, {
                                    minSimilarity: 1,
                                    help: false,
                                    prefix: '.',
                                    usePlugins: [
                                        (0, koishi_nestjs_1.PluginDef)(plugin_adapter_onebot_1["default"], {
                                            bots: [
                                                {
                                                    protocol: 'ws',
                                                    endpoint: config.get('ONEBOT_HOST'),
                                                    token: config.get('ONEBOT_TOKEN'),
                                                    selfId: config.get('ONEBOT_ID')
                                                },
                                            ]
                                        }),
                                    ]
                                }];
                        });
                    }); }
                }),
            ],
            providers: [record_service_1.RecordService, command_service_1.CommandService]
        })
    ], AppModule);
    return AppModule;
}());
exports.AppModule = AppModule;
