import { readPoems } from '../src/utils/reader';
import { getQueryRegex, matchPoem } from '../src/utils/match';

describe('reader', () => {
  it('should read a file', async () => {
    const poems = await readPoems('chinese-poetry/json/poet.song.173000.json');
    expect(poems).toBeInstanceOf(Array);
    expect(poems.length).toBeGreaterThan(0);
    const poem = poems[0];
    console.log(poem);
    expect(poem.author).toBeDefined();
    expect(poem.paragraphs).toBeInstanceOf(Array);
    expect(poem.paragraphs[0]).toBeDefined();

    const regex = getQueryRegex(
      '一（）（）（）（）（）骨，曲身（）（）（）（）（）。',
    );
    console.log(regex.toString());
    const match = matchPoem(poem, regex);
    expect(match).toBeDefined();
    expect(match.poem).toEqual(poem);
    expect(match.matching).toBe('一朝入火纵粉骨，曲身得煖龙蛇伸。');
  });
});
