import { Poem } from '../src/utils/def';
import { getQueryRegex, matchPoem } from '../src/utils/match';

describe('match', () => {
  const poem: Poem = {
    author: '孟浩然',
    title: '春晓',
    paragraphs: ['春眠不觉晓，处处闻啼鸟。', '夜来风雨声，花落知多少。'],
  };
  it('should match a poem', () => {
    const regex = getQueryRegex(
      '（）    （   ）     （）觉（）。（）处（）（）（），',
    );
    console.log(regex.toString());
    const match = matchPoem(poem, regex);
    expect(match).toBeTruthy();
    expect(match.poem).toEqual(poem);
    expect(match.matching).toEqual('春眠不觉晓，处处闻啼鸟。');
  });

  it('it should not match invalid', () => {
    expect(
      matchPoem(
        poem,
        getQueryRegex('（）（）（）叫（）。（）处（）（）（），'),
      ),
    ).toBeFalsy();
  });
});
