import { MatchResult, Poem } from './def';

const replacements = [
  '\uFF0C\u3002\uFF1F\uFF01\uFF1B\u3001\\,\\.\\?\\!\\;',
  '一壹',
  '二贰',
  '三叁',
  '四肆',
  '五伍',
  '六陆',
  '七柒',
  '八捌',
  '九玖',
  '十拾',
  '百佰',
  '千仟',
  '万萬',
];

const replacementsEntry = replacements.map((r) => {
  const wordWithSym = `[${r}]`;
  return {
    word: wordWithSym,
    regex: new RegExp(wordWithSym, 'g'),
  };
});

const nonSym = '[^\uFF0C\u3002\uFF1F\uFF01\uFF1B\u3001\\,\\.\\?\\!\\;]';

export const getQueryRegex = (query: string) => {
  let word = query.trim();
  for (const entry of replacementsEntry) {
    word = word.replace(entry.regex, entry.word);
  }
  word = word
    .replace(/\s*\(\s*\)\s*/g, nonSym)
    .replace(/\s*\uff08\s*\uff09\s*/g, nonSym);
  return new RegExp(word);
};

export const matchPoem = (poem: Poem, regex: RegExp): MatchResult => {
  /*const suffix = 'js';
  const result = await new Promise<MatchResult>((resolve, reject) => {
    const worker = new Worker(
      path.resolve(process.cwd(), 'worker', `match.${suffix}`),
      {
        workerData: {
          poem,
          regex,
        },
      },
    );
    worker.on('message', resolve);
    worker.on('error', reject);
    worker.on('exit', (code) => {
      if (code !== 0)
        reject(new Error(`Worker stopped with exit code ${code}`));
    });
  });*/
  const wholeParagraph = poem.paragraphs.join('');
  const matching = wholeParagraph.match(regex)?.[0];
  if (!matching) return;
  return { matching, poem, found: true };
};
