import * as fs from 'fs';
import path from 'path';
import _ from 'lodash';

export const readFilelist = async () =>
  _.flatten(
    await Promise.all(
      [
        { dir: 'json', prefix: 'poet' },
        { dir: 'ci', prefix: 'ci' },
      ].map(async (entry) =>
        (await fs.promises.readdir(path.join('chinese-poetry', entry.dir)))
          .filter(
            (file) => file.endsWith('json') && file.startsWith(entry.prefix),
          )
          .map((file) => path.join('chinese-poetry', entry.dir, file)),
      ),
    ),
  );
