import { Poem } from './def';
import { traditionToSimple } from 'chinese-simple2traditional';

export const convertPoem = (poem: Poem): Poem => {
  poem.author = traditionToSimple(poem.author);
  poem.paragraphs = poem.paragraphs.map((p) => traditionToSimple(p));
  if (poem.rhythmic) {
    poem.rhythmic = traditionToSimple(poem.rhythmic);
  }
  if (poem.title) {
    poem.title = traditionToSimple(poem.title);
  }
  return poem;
};
