import { getQueryRegex, matchPoem } from './utils/match';
import { readPoems } from './utils/reader';
import _ from 'lodash';
import { readFilelist } from './utils/filelist';
import { MatchResult } from './utils/def';
import moment from 'moment';

async function searchInFile(
  regex: RegExp,
  file: string,
): Promise<MatchResult[]> {
  // console.log(`Searching in ${file} ...`);
  const poems = await readPoems(file);
  const matches = _.compact(
    poems.map((poem) => {
      const result = matchPoem(poem, regex);
      if (result) {
        console.log(
          `Found line:\n${result.matching}\n${poem.title || poem.rhythmic} - ${
            poem.author
          }\n${poem.paragraphs.join('')}\n\n`,
        );
      }
      return result;
    }),
  );
  return matches;
}

export async function search(query: string) {
  const regex = getQueryRegex(query);
  console.log(`Searching for ${regex.toString()} .`);
  const startTime = moment();
  const fileList = await readFilelist();
  const results = _.flatten(
    await Promise.all(fileList.map((file) => searchInFile(regex, file))),
  );
  console.log(
    `Found ${results.length} matches. Time used: ${
      moment().diff(startTime, 'ms') / 1000
    } s.`,
  );
  return results;
}
