NVENC and NvFBC patches for Windows Nvidia drivers
==================================================

![GitHub last commit](https://img.shields.io/github/last-commit/keylase/nvidia-patch.svg) ![Latest GeForce version](https://img.shields.io/badge/latest%20GeForce%20version-551.23-brightgreen.svg) ![Latest Quadro version](https://img.shields.io/badge/latest%20Quadro%20version-536.25-blue.svg)

NVENC patch removes restriction on maximum number of simultaneous NVENC video encoding sessions imposed by Nvidia to consumer-grade GPUs.

NvFBC patch (wrapper) allows to use NvFBC on consumer-grade GPUs. See [**nvfbcwrp** (clickable)](nvfbcwrp) directory for details.

---

If you like this project, best way to contribute is by sending PRs and fixing documentation.

---

## Requirements

- Any of following 64bit operating systems:
  - Windows 7
  - Windows 8
  - Windows 8.1
  - Windows 10
  - Windows 11
  - Windows Server 2008 R2
  - Windows Server 2012
  - Windows Server 2012 R2
  - Windows Server 2016
  - Windows Server 2019
- NVENC-compatible GPU (https://developer.nvidia.com/video-encode-decode-gpu-support-matrix#Encoder)
- Nvidia driver. Patch available for versions in [table below](#version-table).

## NVENC Patch Step-by-Step Guide

1. Download and install latest Nvidia driver supported by this patch.
2. Download latest [Win\_1337\_Apply\_Patch tool](https://github.com/Deltafox79/Win_1337_Apply_Patch/releases/latest) ([IPFS mirror](https://ipfs.io/ipfs/QmXHqNBPtmoX8g5rzg6vNJ9yd275kQtDWuDtVoU4QPfWbu/Win_1337_Apply_Patch_v1.9_By_DFoX.rar)).
3. Save patch(es) corresponding to your system, driver and product version from [Version Table](#version-table) using direct link to the patch (Right Click -> "Save as\.\.\.")
   - *Alternatively you may checkout repo using git or download it as ZIP archive and then locate corresponding .1337 patch file in `win` directory.*
4. Apply x64 library patch to corresponding file in `%WINDIR%\system32\` with the Win\_1337\_Apply\_Patch tool.
   - *If patching fails, close all applications using nvencodeapi64.dll, such as OBS Studio, Plex or Discord.*
5. Apply x86 library patch to corresponding file in `%WINDIR%\SysWOW64\` in the same way as previous one.
   - *If patching fails, close all applications using nvencodeapi.dll, such as OBS Studio, Plex or Discord.*

**Example:** for 64bit Windows 10 running driver version 551.23, use `win10_x64/551.23/nvencodeapi64.1337` against `C:\WINDOWS\system32\nvencodeapi64.dll` **and** `win10_x64/551.23/nvencodeapi.1337` against `C:\WINDOWS\SysWOW64\nvencodeapi.dll`.

You can also use FFmpeg to [verify that NVENC session limit is removed](https://github.com/keylase/nvidia-patch/wiki/Verify-NVENC-patch).

If you experience issues with streaming software based on Nvidia streaming facilities (Nvidia Shield TV, Moonlight), you also have to import few registry values in order to workaround binary signature mismatch. See [**skip\_sig\_check** (clickable)](skip_sig_check) directory for instructions.

A video guide is also available:

[![Video Guide](https://user-images.githubusercontent.com/3524671/84598317-82ab7180-ae72-11ea-8c1b-04842ff589f1.jpg)](https://www.youtube.com/watch?v=0fxu7zbhmrs)

[(IPFS mirror)](https://ipfs.io/ipfs/QmakoWuecX397t7fF8MnTyqG4UC2DrteHrGRmTnwYYKbCK/Nvidia%20-%20Removing%20NVENC%20stream%20limit%20_%20Unlock%20NVENC%20sessions-0fxu7zbhmrs.mkv)

Credits to [TroubleChute channel](https://www.youtube.com/channel/UCkih2oVTbXPEpVwE-U7kmHw/).

## Version Table

### Windows 10, Windows 11 drivers


| Product series | Version | x64 library patch | x86 library patch | Driver link |
|----------------|---------|-------------------|-------------------|-------------|
| GeForce | 391.35 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/391.35/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/391.35/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/391.35/391.35-desktop-win10-64bit-international-whql.exe) |
| GeForce | 417.35 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/417.35/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/417.35/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/417.35/417.35-desktop-win10-64bit-international-whql-rp.exe) |
| GeForce | 417.58 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/417.58/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/417.58/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/417.58hf/417.58-desktop-notebook-win10-64bit-international-whql.hf.exe) |
| GeForce | 417.71 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/417.71/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/417.71/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/417.71/417.71-desktop-win10-64bit-international-whql.exe) |
| GeForce | 418.81 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/418.81/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/418.81/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/418.81/418.81-desktop-win10-64bit-international-whql.exe) |
| GeForce | 418.91 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/418.91/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/418.91/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/418.91/418.91-desktop-win10-64bit-international-whql.exe) |
| GeForce | 419.17 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/419.17/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/419.17/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/419.17/419.17-desktop-win10-64bit-international-whql.exe) |
| GeForce | 419.35 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/419.35/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/419.35/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/419.35/419.35-desktop-win10-64bit-international-whql-rp.exe) |
| GeForce | 419.67 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/419.67/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/419.67/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/419.67/419.67-desktop-win10-64bit-international-whql.exe) |
| GeForce | 419.67 CRD | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/nsd_419.67/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/nsd_419.67/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/419.67/419.67-notebook-win10-64bit-international-crd-whql.exe) |
| GeForce | 425.31 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/425.31/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/425.31/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/425.31/425.31-desktop-win10-64bit-international-whql.exe) |
| GeForce | 430.39 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/430.39/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/430.39/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/430.39/430.39-desktop-win10-64bit-international-whql.exe) |
| GeForce | 430.64 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/430.64/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/430.64/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/430.64/430.64-desktop-win10-64bit-international-whql.exe) |
| GeForce | 430.86 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/430.86/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/430.86/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/430.86/430.86-desktop-win10-64bit-international-whql.exe) |
| GeForce | 430.86 Studio Driver | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/nsd_430.86/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/nsd_430.86/nvencodeapi.1337) | [Driver link](https://international-gfe.download.nvidia.com/Windows/430.86/430.86-desktop-win10-64bit-international-nsd-whql-g.exe) |
| GeForce | 431.36 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/431.36/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/431.36/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/431.36/431.36-desktop-win10-64bit-international-whql.exe) |
| GeForce | 431.60 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/431.60/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/431.60/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/431.60/431.60-desktop-win10-64bit-international-whql.exe) |
| GeForce | 431.70 Studio Driver | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/nsd_431.70/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/nsd_431.70/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/431.70/431.70-notebook-win10-64bit-international-nsd-whql.exe) |
| GeForce | 431.86 Studio Driver | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/nsd_431.86/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/nsd_431.86/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/431.86/431.86-notebook-win10-64bit-international-nsd-whql.exe) |
| GeForce | 436.02 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/436.02/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/436.02/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/436.02/436.02-desktop-win10-64bit-international-whql-rp.exe) |
| GeForce | 436.15 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/436.15/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/436.15/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/436.15/436.15-desktop-win10-64bit-international-whql.exe) |
| GeForce | 436.30 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/436.30/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/436.30/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/436.30/436.30-desktop-win10-64bit-international-whql.exe) |
| GeForce | 436.48 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/436.48/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/436.48/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/436.48/436.48-desktop-win10-64bit-international-whql.exe) |
| GeForce | 440.97 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/440.97/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/440.97/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/440.97/440.97-desktop-win10-64bit-international-whql.exe) |
| GeForce | 441.08 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/441.08/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/441.08/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/441.08/441.08-desktop-win10-64bit-international-whql.exe) |
| GeForce | 441.12 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/441.12/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/441.12/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/441.12/441.12-desktop-win10-64bit-international-whql.exe) |
| GeForce | 441.12 Studio Driver | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/nsd_441.12/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/nsd_441.12/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/441.12/441.12-desktop-win10-64bit-international-nsd-whql.exe) |
| GeForce | 441.20 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/441.20/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/441.20/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/441.20/441.20-desktop-win10-64bit-international-whql.exe) |
| GeForce | 441.28 Studio Driver | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/nsd_441.28/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/nsd_441.28/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/441.28/441.28-desktop-win10-64bit-international-nsd-whql.exe) |
| GeForce | 441.41 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/441.41/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/441.41/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/441.41/441.41-desktop-win10-64bit-international-whql.exe) |
| GeForce | 441.66 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/441.66/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/441.66/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/441.66/441.66-desktop-win10-64bit-international-whql.exe) |
| GeForce | 441.66 Studio Driver | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/nsd_441.66/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/nsd_441.66/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/441.66/441.66-desktop-win10-64bit-international-nsd-whql.exe) |
| GeForce | 441.87 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/441.87/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/441.87/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/441.87/441.87-desktop-win10-64bit-international-whql.exe) |
| GeForce | 441.99 Vulkan Beta | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/441.99/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/441.99/nvencodeapi.1337) |  |
| GeForce | 442.19 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/442.19/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/442.19/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/442.19/442.19-desktop-win10-64bit-international-whql.exe) |
| GeForce | 442.19 Studio Driver | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/nsd_442.19/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/nsd_442.19/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/442.19/442.19-desktop-win10-64bit-international-nsd-whql.exe) |
| GeForce | 442.36 Vulkan Beta | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/442.36/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/442.36/nvencodeapi.1337) |  |
| GeForce | 442.50 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/442.50/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/442.50/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/442.50/442.50-desktop-win10-64bit-international-whql.exe) |
| GeForce | 442.59 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/442.59/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/442.59/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/442.59/442.59-desktop-win10-64bit-international-whql.exe) |
| GeForce | 442.74 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/442.74/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/442.74/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/442.74/442.74-desktop-win10-64bit-international-whql.exe) |
| GeForce | 442.75 Vulkan Beta | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/442.75/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/442.75/nvencodeapi.1337) |  |
| GeForce | 442.77 Vulkan Beta | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/442.77/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/442.77/nvencodeapi.1337) |  |
| GeForce | 442.81 Vulkan Beta | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/442.81/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/442.81/nvencodeapi.1337) |  |
| GeForce | 442.88 Vulkan Beta | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/442.88/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/442.88/nvencodeapi.1337) |  |
| GeForce | 442.92 Studio Driver | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/nsd_442.92/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/nsd_442.92/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/442.92/442.92-desktop-win10-64bit-international-nsd-whql.exe) |
| GeForce | 442.98 Vulkan Beta | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/442.98/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/442.98/nvencodeapi.1337) |  |
| GeForce | 443.09 Vulkan Beta | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/443.09/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/443.09/nvencodeapi.1337) |  |
| GeForce | 443.15 Vulkan Beta | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/443.15/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/443.15/nvencodeapi.1337) |  |
| GeForce | 443.24 Vulkan Beta | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/443.24/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/443.24/nvencodeapi.1337) |  |
| GeForce | 443.41 Vulkan Beta | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/443.41/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/443.41/nvencodeapi.1337) |  |
| GeForce | 445.75 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/445.75/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/445.75/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/445.75/445.75-desktop-win10-64bit-international-whql.exe) |
| GeForce | 445.87 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/445.87/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/445.87/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/445.87/445.87-desktop-win10-64bit-international-whql.exe) |
| GeForce | 446.14 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/446.14/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/446.14/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/446.14/446.14-desktop-win10-64bit-international-whql.exe) |
| GeForce | 451.48 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/451.48/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/451.48/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/451.48/451.48-desktop-win10-64bit-international-whql.exe) |
| GeForce | 451.48 Studio Driver | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/nsd_451.48/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/nsd_451.48/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/451.48/451.48-desktop-win10-64bit-international-nsd-whql.exe) |
| GeForce | 451.52 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/451.52/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/451.52/nvencodeapi.1337) |  |
| GeForce | 451.67 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/451.67/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/451.67/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/451.67/451.67-desktop-win10-64bit-international-whql.exe) |
| GeForce | 451.74 Vulkan Beta | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/451.74/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/451.74/nvencodeapi.1337) |  |
| GeForce | 451.77 Studio Driver | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/nsd_451.77/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/nsd_451.77/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/451.77/451.77-desktop-win10-64bit-international-nsd-whql.exe) |
| GeForce | 451.79 Vulkan Beta | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/451.79/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/451.79/nvencodeapi.1337) |  |
| GeForce | 451.98 Vulkan Beta | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/451.98/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/451.98/nvencodeapi.1337) |  |
| GeForce | 452.06 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/452.06/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/452.06/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/452.06/452.06-desktop-win10-64bit-international-whql.exe) |
| GeForce | 452.06 Studio Driver | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/nsd_452.06/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/nsd_452.06/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/452.06/452.06-desktop-win10-64bit-international-nsd-whql.exe) |
| GeForce | 452.28 Vulkan Beta | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/452.28/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/452.28/nvencodeapi.1337) |  |
| GeForce | 456.38 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/456.38/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/456.38/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/456.38/456.38-desktop-win10-64bit-international-whql.exe) |
| GeForce | 456.38 Studio Driver | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/nsd_456.38/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/nsd_456.38/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/456.38/456.38-desktop-win10-64bit-international-nsd-whql.exe) |
| GeForce | 456.55 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/456.55/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/456.55/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/456.55/456.55-desktop-win10-64bit-international-whql.exe) |
| GeForce | 456.62 Vulkan Beta | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/456.62/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/456.62/nvencodeapi.1337) |  |
| GeForce | 456.71 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/456.71/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/456.71/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/456.71/456.71-desktop-win10-64bit-international-whql.exe) |
| GeForce | 456.71 Studio Driver | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/nsd_456.71/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/nsd_456.71/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/456.71/456.71-desktop-win10-64bit-international-nsd-whql.exe) |
| GeForce | 456.80 Vulkan Beta | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/456.80/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/456.80/nvencodeapi.1337) |  |
| GeForce | 457.00 Vulkan Beta | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/457.00/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/457.00/nvencodeapi.1337) |  |
| GeForce | 457.09 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/457.09/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/457.09/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/457.09/457.09-desktop-win10-64bit-international-whql.exe) |
| GeForce | 457.30 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/457.30/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/457.30/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/457.30/457.30-desktop-win10-64bit-international-whql.exe) |
| GeForce | 457.30 Studio Driver | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/nsd_457.30/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/nsd_457.30/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/457.30/457.30-desktop-win10-64bit-international-nsd-whql.exe) |
| GeForce | 457.33 Vulkan Beta | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/457.33/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/457.33/nvencodeapi.1337) |  |
| GeForce | 457.44 Vulkan Beta | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/457.44/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/457.44/nvencodeapi.1337) |  |
| GeForce | 457.51 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/457.51/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/457.51/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/457.51/457.51-desktop-win10-64bit-international-whql.exe) |
| GeForce | 457.88 Vulkan Beta | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/457.88/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/457.88/nvencodeapi.1337) |  |
| GeForce | 457.91 Vulkan Beta | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/457.91/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/457.91/nvencodeapi.1337) |  |
| GeForce | 457.96 Vulkan Beta | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/457.96/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/457.96/nvencodeapi.1337) |  |
| GeForce | 458.06 Vulkan Beta | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/458.06/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/458.06/nvencodeapi.1337) |  |
| GeForce | 460.79 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/460.79/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/460.79/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/460.79/460.79-desktop-win10-64bit-international-whql.exe) |
| GeForce | 460.89 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/460.89/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/460.89/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/460.89/460.89-desktop-win10-64bit-international-whql.exe) |
| GeForce | 460.89 Studio Driver | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/nsd_460.89/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/nsd_460.89/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/460.89/460.89-desktop-win10-64bit-international-nsd-whql.exe) |
| GeForce | 461.09 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/461.09/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/461.09/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/461.09/461.09-desktop-win10-64bit-international-whql.exe) |
| GeForce | 461.40 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/461.40/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/461.40/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/461.40/461.40-desktop-win10-64bit-international-whql.exe) |
| GeForce | 461.40 Studio Driver | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/nsd_461.40/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/nsd_461.40/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/461.40/461.40-desktop-win10-64bit-international-nsd-whql.exe) |
| GeForce | 461.72 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/461.72/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/461.72/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/461.72/461.72-desktop-win10-64bit-international-whql.exe) |
| GeForce | 461.72 Studio Driver | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/nsd_461.72/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/nsd_461.72/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/461.72/461.72-desktop-win10-64bit-international-nsd-whql.exe) |
| GeForce | 461.92 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/461.92/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/461.92/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/461.92/461.92-desktop-win10-64bit-international-whql.exe) |
| GeForce | 461.92 Studio Driver | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/nsd_461.92/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/nsd_461.92/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/461.92/461.92-desktop-win10-64bit-international-nsd-whql.exe) |
| GeForce | 462.31 Studio Driver | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/nsd_462.31/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/nsd_462.31/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/462.31/462.31-desktop-win10-64bit-international-nsd-whql.exe) |
| GeForce | 462.59 Studio Driver | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/nsd_462.59/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/nsd_462.59/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/462.59/462.59-desktop-win10-64bit-international-nsd-whql.exe) |
| GeForce | 465.21 Drivers for CUDA on WSL | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/465.21/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/465.21/nvencodeapi.1337) |  |
| GeForce | 465.89 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/465.89/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/465.89/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/465.89/465.89-desktop-win10-64bit-international-whql.exe) |
| GeForce | 466.11 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/466.11/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/466.11/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/466.11/466.11-desktop-win10-64bit-international-whql.exe) |
| GeForce | 466.27 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/466.27/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/466.27/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/466.27/466.27-desktop-win10-64bit-international-whql.exe) |
| GeForce | 466.47 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/466.47/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/466.47/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/466.47/466.47-desktop-win10-64bit-international-whql.exe) |
| GeForce | 466.63 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/466.63/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/466.63/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/466.63/466.63-desktop-win10-64bit-international-whql.exe) |
| GeForce | 466.77 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/466.77/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/466.77/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/466.77/466.77-desktop-win10-64bit-international-whql.exe) |
| GeForce | 471.11 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/471.11/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/471.11/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/471.11/471.11-desktop-win10-64bit-international-whql.exe) |
| GeForce | 471.11 Studio Driver | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/nsd_471.11/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/nsd_471.11/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/471.11/471.11-desktop-win10-64bit-international-nsd-whql.exe) |
| GeForce | 471.41 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/471.41/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/471.41/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/471.41/471.41-desktop-win10-64bit-international-whql.exe) |
| GeForce | 471.41 Studio Driver | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/nsd_471.41/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/nsd_471.41/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/471.41/471.41-desktop-win10-64bit-international-nsd-whql.exe) |
| GeForce | 471.68 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/471.68/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/471.68/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/471.68/471.68-desktop-win10-win11-64bit-international-whql.exe) |
| GeForce | 471.68 Studio Driver | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/nsd_471.68/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/nsd_471.68/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/471.68/471.68-desktop-win10-win11-64bit-international-nsd-whql.exe) |
| GeForce | 471.96 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/471.96/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/471.96/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/471.96/471.96-desktop-win10-win11-64bit-international-whql.exe) |
| GeForce | 472.12 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/472.12/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/472.12/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/472.12/472.12-desktop-win10-win11-64bit-international-whql.exe) |
| GeForce | 472.12 Studio Driver | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/nsd_472.12/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/nsd_472.12/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/472.12/472.12-desktop-win10-win11-64bit-international-nsd-whql.exe) |
| GeForce | 472.84 Studio Driver | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/nsd_472.84/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/nsd_472.84/nvencodeapi.1337) | [Driver link](http://international.download.nvidia.com/Windows/472.84/472.84-desktop-win10-win11-64bit-international-nsd-whql.exe) |
| GeForce | 474.14 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/474.14/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/474.14/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/474.14/474.14-desktop-win10-win11-64bit-international-dch-whql.exe) |
| GeForce | 511.23 DCH | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/511.23/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/511.23/nvencodeapi.1337) | [Driver link](http://international.download.nvidia.com/Windows/511.23/511.23-desktop-win10-win11-64bit-international-dch-whql.exe) |
| GeForce | 511.65 Studio Driver | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/nsd_511.65/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/nsd_511.65/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/511.65/511.65-desktop-win10-win11-64bit-international-nsd-dch-whql.exe) |
| GeForce | 511.79 DCH | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/511.79/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/511.79/nvencodeapi.1337) | [Driver link](http://international.download.nvidia.com/Windows/511.79/511.79-desktop-win10-win11-64bit-international-dch-whql.exe) |
| GeForce | 512.15 DCH | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/512.15/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/512.15/nvencodeapi.1337) | [Driver link](http://international.download.nvidia.com/Windows/512.15/512.15-desktop-win10-win11-64bit-international-dch-whql.exe) |
| GeForce | 512.15 Studio Driver | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/nsd_512.15/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/nsd_512.15/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/512.15/512.15-desktop-win10-win11-64bit-international-nsd-dch-whql.exe) |
| GeForce | 512.59 DCH | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/512.59/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/512.59/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/512.59/512.59-desktop-win10-win11-64bit-international-dch-whql-g.exe) |
| GeForce | 512.59 Studio Driver | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/nsd_512.59/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/nsd_512.59/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/512.59/512.59-desktop-win10-win11-64bit-international-nsd-dch-whql-g.exe) |
| GeForce | 512.77 DCH | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/512.77/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/512.77/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/512.77/512.77-desktop-win10-win11-64bit-international-dch-whql.exe) |
| GeForce | 512.95 DCH | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/512.95/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/512.95/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/512.95/512.95-desktop-win10-win11-64bit-international-dch-whql.exe) |
| GeForce | 516.40 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/516.40/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/516.40/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/516.40/516.40-desktop-win10-win11-64bit-international-dch-whql.exe) |
| GeForce | 516.59 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/516.59/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/516.59/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/516.59/516.59-desktop-win10-win11-64bit-international-dch-whql.exe) |
| GeForce | 516.79 DCH (Hotfix) | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/516.79/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/516.79/nvencodeapi.1337) | [Driver link](https://international-gfe.download.nvidia.com/Windows/516.79hf/516.79-desktop-notebook-win10-win11-64bit-international-dch.hf.exe) |
| GeForce | 516.93 Studio Driver | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/nsd_516.93/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/nsd_516.93/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/516.93/516.93-notebook-win10-win11-64bit-international-nsd-dch-whql.exe) |
| GeForce | 516.94 DCH | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/516.94/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/516.94/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/516.94/516.94-desktop-win10-win11-64bit-international-dch-whql.exe) |
| GeForce | 517.40 Studio Driver | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/nsd_517.40/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/nsd_517.40/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/517.40/517.40-desktop-win10-win11-64bit-international-nsd-dch-whql.exe) |
| GeForce | 517.48 DCH | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/517.48/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/517.48/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/517.48/517.48-desktop-win10-win11-64bit-international-dch-whql.exe) |
| GeForce | 522.25 DCH | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/522.25/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/522.25/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/522.25/522.25-desktop-win10-win11-64bit-international-dch-whql.exe) |
| GeForce | 522.30 Studio Driver | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/nsd_522.30/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/nsd_522.30/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/522.30/522.30-desktop-win10-win11-64bit-international-nsd-dch-whql.exe) |
| GeForce | 526.47 DCH | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/526.47/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/526.47/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/526.47/526.47-desktop-win10-win11-64bit-international-dch-whql.exe) |
| GeForce | 526.86 DCH | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/526.86/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/526.86/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/526.86/526.86-desktop-win10-win11-64bit-international-dch-whql.exe) |
| GeForce | 526.98 DCH | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/526.98/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/526.98/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/526.98/526.98-desktop-win10-win11-64bit-international-dch-whql.exe) |
| GeForce | 527.37 DCH | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/527.37/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/527.37/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/527.37/527.37-desktop-win10-win11-64bit-international-dch-whql.exe) |
| GeForce | 527.56 DCH | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/527.56/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/527.56/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/527.56/527.56-desktop-win10-win11-64bit-international-dch-whql.exe) |
| GeForce | 527.56 Studio Driver | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/nsd_527.56/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/nsd_527.56/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/527.56/527.56-desktop-win10-win11-64bit-international-nsd-dch-whql.exe) |
| GeForce | 528.02 DCH | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/528.02/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/528.02/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/528.02/528.02-desktop-win10-win11-64bit-international-dch-whql.exe) |
| GeForce | 528.24 DCH | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/528.24/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/528.24/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/528.24/528.24-desktop-win10-win11-64bit-international-dch-whql.exe) |
| GeForce | 528.49 DCH | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/528.49/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/528.49/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/528.49/528.49-desktop-win10-win11-64bit-international-dch-whql.exe) |
| GeForce | 531.18 DCH | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/531.18/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/531.18/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/531.18/531.18-desktop-win10-win11-64bit-international-dch-whql.exe) |
| GeForce | 531.26 DCH (Hotfix) | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/531.26/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/531.26/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/531.26hf/531.26-desktop-notebook-win10-win11-64bit-international-dch.hf.exe) |
| GeForce | 531.29 DCH | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/531.29/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/531.29/nvencodeapi.1337) | [Driver link](https://us.download.nvidia.com/Windows/531.29/531.29-desktop-win10-win11-64bit-international-dch-whql.exe) |
| GeForce | 531.41 DCH | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/531.41/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/531.41/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/531.41/531.41-desktop-win10-win11-64bit-international-dch-whql.exe) |
| GeForce | 531.41 Studio Driver | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/nsd_531.41/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/nsd_531.41/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/531.41/531.41-desktop-win10-win11-64bit-international-nsd-dch-whql.exe) |
| GeForce | 531.58 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/531.58/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/531.58/nvencodeapi.1337) | [Driver link](https://international-gfe.download.nvidia.com/Windows/531.58hf/531.58-desktop-notebook-win10-win11-64bit-international-dch.hf.exe) |
| GeForce | 531.61 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/531.61/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/531.61/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/531.61/531.61-desktop-win10-win11-64bit-international-dch-whql.exe) |
| GeForce | 531.68 DCH | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/531.68/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/531.68/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/531.68/531.68-desktop-win10-win11-64bit-international-dch-whql.exe) |
| GeForce | 531.79 DCH | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/531.79/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/531.79/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/531.79/531.79-desktop-win10-win11-64bit-international-dch-whql.exe) |
| GeForce | 532.03 DCH | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/532.03/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/532.03/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/532.03/532.03-desktop-win10-win11-64bit-international-dch-whql.exe) |
| GeForce | 535.98 DCH / Studio Driver | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/535.98/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/535.98/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/535.98/535.98-desktop-win10-win11-64bit-international-dch-whql.exe) |
| GeForce | 536.09 DCH (Hotfix) | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/536.09/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/536.09/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/536.09hf/536.09-desktop-notebook-win10-win11-64bit-international-dch.hf.exe) |
| GeForce | 536.23 DCH | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/536.23/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/536.23/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/536.23/536.23-desktop-win10-win11-64bit-international-dch-whql.exe) |
| GeForce | 536.40 DCH / Studio Driver | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/536.40/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/536.40/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/536.40/536.40-desktop-win10-win11-64bit-international-dch-whql.exe) |
| GeForce | 536.67 DCH / Studio Driver | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/536.67/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/536.67/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/536.67/536.67-desktop-win10-win11-64bit-international-dch-whql.exe) |
| GeForce | 536.99 DCH / Studio Driver | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/536.99/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/536.99/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/536.99/536.99-desktop-win10-win11-64bit-international-dch-whql.exe) |
| GeForce | 537.13 DCH | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/537.13/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/537.13/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/537.13/537.13-desktop-win10-win11-64bit-international-dch-whql.exe) |
| GeForce | 537.34 DCH | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/537.34/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/537.34/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/537.34/537.34-desktop-win10-win11-64bit-international-dch-whql.exe) |
| GeForce | 537.42 DCH / Studio Driver | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/537.42/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/537.42/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/537.42/537.42-desktop-win10-win11-64bit-international-dch-whql.exe) |
| GeForce | 537.58 DCH / Studio Driver | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/537.58/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/537.58/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/537.58/537.58-desktop-win10-win11-64bit-international-dch-whql.exe) |
| GeForce | 537.72 Vulkan Beta | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/537.72/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/537.72/nvencodeapi.1337) |  |
| GeForce | 545.84 DCH | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/545.84/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/545.84/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/545.84/545.84-desktop-win10-win11-64bit-international-dch-whql.exe) |
| GeForce | 545.92 DCH | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/545.92/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/545.92/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/545.92/545.92-desktop-win10-win11-64bit-international-dch-whql.exe) |
| GeForce | 546.01 DCH / Studio Driver | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/546.01/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/546.01/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/546.01/546.01-desktop-win10-win11-64bit-international-dch-whql.exe) |
| GeForce | 546.08 DCH (Hotfix) | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/546.08/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/546.08/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/546.08hf/546.08-desktop-notebook-win10-win11-64bit-international-dch.hf.exe) |
| GeForce | 546.17 DCH | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/546.17/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/546.17/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/546.17/546.17-desktop-win10-win11-64bit-international-dch-whql.exe) |
| GeForce | 546.29 DCH | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/546.29/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/546.29/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/546.29/546.29-desktop-win10-win11-64bit-international-dch-whql.exe) |
| GeForce | 546.31 DCH (Hotfix) | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/546.31/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/546.31/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/546.31hf/546.31-desktop-notebook-win10-win11-64bit-international-dch.hf.exe) |
| GeForce | 546.33 DCH / Studio Driver | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/546.33/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/546.33/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/546.33/546.33-desktop-win10-win11-64bit-international-dch-whql.exe) |
| GeForce | 546.65 DCH | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/546.65/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/546.65/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/546.65/546.65-desktop-win10-win11-64bit-international-dch-whql.exe) |
| GeForce | 551.23 DCH / Studio Driver | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/551.23/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/551.23/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/551.23/551.23-desktop-win10-win11-64bit-international-dch-whql.exe) |


| Product series | Version | x64 library patch | x86 library patch | Driver link |
|----------------|---------|-------------------|-------------------|-------------|
| Quadro | 416.78 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/quadro_416.78/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/quadro_416.78/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/Quadro_Certified/416.78/416.78-quadro-desktop-notebook-win10-64bit-international-whql.exe) |
| Quadro | 418.81 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/quadro_418.81/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/quadro_418.81/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/Quadro_Certified/418.81/418.81-quadro-desktop-notebook-win10-64bit-international-whql.exe) |
| Quadro | 419.17 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/quadro_419.17/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/quadro_419.17/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/Quadro_Certified/419.17/419.17-quadro-desktop-notebook-win10-64bit-international-whql.exe) |
| Quadro | 419.67 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/quadro_419.67/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/quadro_419.67/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/Quadro_Certified/419.67/419.67-quadro-desktop-notebook-win10-64bit-international-whql.exe) |
| Quadro | 425.31 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/quadro_425.31/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/quadro_425.31/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/Quadro_Certified/425.31/425.31-quadro-desktop-notebook-win10-64bit-international-whql.exe) |
| Quadro | 430.39 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/quadro_430.39/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/quadro_430.39/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/Quadro_Certified/430.39/430.39-quadro-desktop-notebook-win10-64bit-international-whql.exe) |
| Quadro | 430.64 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/quadro_430.64/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/quadro_430.64/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/Quadro_Certified/430.64/430.64-quadro-desktop-notebook-win10-64bit-international-whql.exe) |
| Quadro | 430.86 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/quadro_430.86/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/quadro_430.86/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/Quadro_Certified/430.86/430.86-quadro-desktop-notebook-win10-64bit-international-whql.exe) |
| Quadro | 431.02 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/quadro_431.02/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/quadro_431.02/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/Quadro_Certified/431.02/431.02-quadro-desktop-notebook-win10-64bit-international-whql.exe) |
| Quadro | 431.70 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/quadro_431.70/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/quadro_431.70/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/Quadro_Certified/431.70/431.70-quadro-desktop-notebook-win10-64bit-international-whql.exe) |
| Quadro | 431.86 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/quadro_431.86/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/quadro_431.86/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/Quadro_Certified/431.86/431.86-quadro-desktop-notebook-win10-64bit-international-whql.exe) |
| Quadro | 431.94 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/quadro_431.94/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/quadro_431.94/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/Quadro_Certified/431.94/431.94-quadro-desktop-notebook-win10-64bit-international-whql.exe) |
| Quadro | 436.02 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/quadro_436.02/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/quadro_436.02/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/Quadro_Certified/436.02/436.02-quadro-desktop-notebook-win10-64bit-international-whql.exe) |
| Quadro | 436.30 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/quadro_436.30/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/quadro_436.30/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/Quadro_Certified/436.30/436.30-quadro-desktop-notebook-win10-64bit-international-whql.exe) |
| Quadro | 440.97 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/quadro_440.97/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/quadro_440.97/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/Quadro_Certified/440.97/440.97-quadro-desktop-notebook-win10-64bit-international-whql.exe) |
| Quadro | 441.12 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/quadro_441.12/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/quadro_441.12/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/Quadro_Certified/441.12/441.12-quadro-desktop-notebook-win10-64bit-international-whql.exe) |
| Quadro | 441.28 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/quadro_441.28/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/quadro_441.28/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/Quadro_Certified/441.28/441.28-quadro-desktop-notebook-win10-64bit-international-whql.exe) |
| Quadro | 441.66 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/quadro_441.66/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/quadro_441.66/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/Quadro_Certified/441.66/441.66-quadro-desktop-notebook-win10-64bit-international-whql.exe) |
| Quadro | 442.19 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/quadro_442.19/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/quadro_442.19/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/Quadro_Certified/442.19/442.19-quadro-desktop-notebook-win10-64bit-international-whql.exe) |
| Quadro | 442.50 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/quadro_442.50/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/quadro_442.50/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/Quadro_Certified/442.50/442.50-quadro-desktop-notebook-win10-64bit-international-whql.exe) |
| Quadro | 442.74 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/quadro_442.74/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/quadro_442.74/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/Quadro_Certified/442.74/442.74-quadro-desktop-notebook-win10-64bit-international-whql.exe) |
| Quadro | 442.92 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/quadro_442.92/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/quadro_442.92/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/Quadro_Certified/442.92/442.92-quadro-desktop-notebook-win10-64bit-international-whql.exe) |
| Quadro | 451.48 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/quadro_451.48/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/quadro_451.48/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/Quadro_Certified/451.48/451.48-quadro-desktop-notebook-win10-64bit-international-whql.exe) |
| Quadro | 451.77 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/quadro_451.77/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/quadro_451.77/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/Quadro_Certified/451.77/451.77-quadro-desktop-notebook-win10-64bit-international-whql.exe) |
| Quadro | 452.06 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/quadro_452.06/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/quadro_452.06/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/Quadro_Certified/452.06/452.06-quadro-desktop-notebook-win10-64bit-international-whql.exe) |
| Quadro | 452.39 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/quadro_452.39/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/quadro_452.39/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/Quadro_Certified/452.39/452.39-quadro-desktop-notebook-win10-64bit-international-whql.exe) |
| Quadro | 452.57 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/quadro_452.57/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/quadro_452.57/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/Quadro_Certified/452.57/452.57-quadro-desktop-notebook-win10-64bit-international-whql.exe) |
| Quadro | 456.71 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/quadro_456.71/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/quadro_456.71/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/Quadro_Certified/456.71/456.71-quadro-desktop-notebook-win10-64bit-international-whql.exe) |
| Quadro | 457.09 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/quadro_457.09/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/quadro_457.09/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/Quadro_Certified/457.09/457.09-quadro-desktop-notebook-win10-64bit-international-whql.exe) |
| Quadro | 460.89 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/quadro_460.89/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/quadro_460.89/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/Quadro_Certified/460.89/460.89-quadro-rtx-desktop-notebook-win10-64bit-international-whql.exe) |
| Quadro | 461.09 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/quadro_461.09/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/quadro_461.09/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/Quadro_Certified/461.09/461.09-quadro-rtx-desktop-notebook-win10-64bit-international-whql.exe) |
| Quadro | 461.40 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/quadro_461.40/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/quadro_461.40/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/Quadro_Certified/461.40/461.40-quadro-rtx-desktop-notebook-win10-64bit-international-whql.exe) |
| Quadro | 461.72 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/quadro_461.72/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/quadro_461.72/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/Quadro_Certified/461.72/461.72-quadro-rtx-desktop-notebook-win10-64bit-international-whql.exe) |
| Quadro | 461.92 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/quadro_461.92/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/quadro_461.92/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/Quadro_Certified/461.92/461.92-quadro-rtx-desktop-notebook-win10-64bit-international-whql.exe) |
| Quadro | 462.31 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/quadro_462.31/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/quadro_462.31/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/Quadro_Certified/462.31/462.31-quadro-rtx-desktop-notebook-win10-64bit-international-whql.exe) |
| Quadro | 462.59 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/quadro_462.59/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/quadro_462.59/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/Quadro_Certified/462.59/462.59-quadro-rtx-desktop-notebook-win10-64bit-international-whql.exe) |
| Quadro | 462.96 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/quadro_462.96/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/quadro_462.96/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/Quadro_Certified/462.96/462.96-quadro-rtx-desktop-notebook-win10-64bit-international-whql.exe) |
| Quadro | 465.89 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/quadro_465.89/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/quadro_465.89/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/Quadro_Certified/465.89/465.89-quadro-rtx-desktop-notebook-win10-64bit-international-whql.exe) |
| Quadro | 471.11 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/quadro_471.11/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/quadro_471.11/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/Quadro_Certified/471.11/471.11-quadro-rtx-desktop-notebook-win10-64bit-international-whql.exe) |
| Quadro | 471.68 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/quadro_471.68/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/quadro_471.68/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/Quadro_Certified/471.68/471.68-quadro-rtx-desktop-notebook-win10-win11-64bit-international-whql.exe) |
| Quadro | 472.12 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/quadro_472.12/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/quadro_472.12/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/Quadro_Certified/472.12/472.12-quadro-rtx-desktop-notebook-win10-win11-64bit-international-whql.exe) |
| Quadro | 472.84 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/quadro_472.84/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/quadro_472.84/nvencodeapi.1337) | [Driver link](http://international.download.nvidia.com/Windows/Quadro_Certified/472.84/472.84-quadro-rtx-desktop-notebook-win10-win11-64bit-international-whql.exe) |
| Quadro | 526.67 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/quadro_526.67/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/quadro_526.67/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/Quadro_Certified/526.67/526.67-quadro-rtx-desktop-notebook-win10-win11-64bit-international-dch-whql.exe) |
| Quadro | 536.25 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/quadro_536.25/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win10_x64/quadro_536.25/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/Quadro_Certified/536.25/536.25-quadro-rtx-desktop-notebook-win10-win11-64bit-international-dch-whql.exe) |


### Windows 7, Windows 8, Windows 8.1 drivers


| Product series | Version | x64 library patch | x86 library patch | Driver link |
|----------------|---------|-------------------|-------------------|-------------|
| GeForce | 431.60 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/431.60/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/431.60/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/431.60/431.60-desktop-win8-win7-64bit-international-whql.exe) |
| GeForce | 436.02 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/436.02/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/436.02/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/436.02/436.02-desktop-win8-win7-64bit-international-whql-rp.exe) |
| GeForce | 436.15 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/436.15/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/436.15/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/436.15/436.15-desktop-win8-win7-64bit-international-whql.exe) |
| GeForce | 436.30 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/436.30/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/436.30/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/436.30/436.30-desktop-win8-win7-64bit-international-whql.exe) |
| GeForce | 436.48 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/436.48/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/436.48/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/436.48/436.48-desktop-win8-win7-64bit-international-whql.exe) |
| GeForce | 440.97 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/440.97/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/440.97/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/440.97/440.97-desktop-win8-win7-64bit-international-whql.exe) |
| GeForce | 441.08 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/441.08/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/441.08/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/441.08/441.08-desktop-win8-win7-64bit-international-whql.exe) |
| GeForce | 441.12 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/441.12/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/441.12/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/441.12/441.12-desktop-win8-win7-64bit-international-whql.exe) |
| GeForce | 441.20 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/441.20/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/441.20/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/441.20/441.20-desktop-win8-win7-64bit-international-whql.exe) |
| GeForce | 441.41 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/441.41/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/441.41/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/441.41/441.41-desktop-win8-win7-64bit-international-whql.exe) |
| GeForce | 441.66 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/441.66/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/441.66/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/441.66/441.66-desktop-win8-win7-64bit-international-whql.exe) |
| GeForce | 441.87 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/441.87/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/441.87/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/441.87/441.87-desktop-win8-win7-64bit-international-whql.exe) |
| GeForce | 441.99 Vulkan Beta | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/441.99/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/441.99/nvencodeapi.1337) |  |
| GeForce | 442.36 Vulkan Beta | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/442.36/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/442.36/nvencodeapi.1337) |  |
| GeForce | 442.50 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/442.50/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/442.50/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/442.50/442.50-desktop-win8-win7-64bit-international-whql.exe) |
| GeForce | 442.59 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/442.59/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/442.59/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/442.59/442.59-desktop-win8-win7-64bit-international-whql.exe) |
| GeForce | 442.74 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/442.74/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/442.74/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/442.74/442.74-desktop-win8-win7-64bit-international-whql.exe) |
| GeForce | 442.75 Vulkan Beta | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/442.75/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/442.75/nvencodeapi.1337) |  |
| GeForce | 442.77 Vulkan Beta | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/442.77/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/442.77/nvencodeapi.1337) |  |
| GeForce | 442.81 Vulkan Beta | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/442.81/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/442.81/nvencodeapi.1337) |  |
| GeForce | 442.88 Vulkan Beta | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/442.88/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/442.88/nvencodeapi.1337) |  |
| GeForce | 442.98 Vulkan Beta | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/442.98/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/442.98/nvencodeapi.1337) |  |
| GeForce | 443.09 Vulkan Beta | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/443.09/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/443.09/nvencodeapi.1337) |  |
| GeForce | 443.15 Vulkan Beta | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/443.15/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/443.15/nvencodeapi.1337) |  |
| GeForce | 443.24 Vulkan Beta | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/443.24/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/443.24/nvencodeapi.1337) |  |
| GeForce | 443.41 Vulkan Beta | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/443.41/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/443.41/nvencodeapi.1337) |  |
| GeForce | 445.75 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/445.75/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/445.75/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/445.75/445.75-desktop-win8-win7-64bit-international-whql.exe) |
| GeForce | 445.87 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/445.87/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/445.87/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/445.87/445.87-desktop-win8-win7-64bit-international-whql.exe) |
| GeForce | 446.14 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/446.14/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/446.14/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/446.14/446.14-desktop-win8-win7-64bit-international-whql.exe) |
| GeForce | 451.48 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/451.48/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/451.48/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/451.48/451.48-desktop-win8-win7-64bit-international-whql.exe) |
| GeForce | 451.67 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/451.67/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/451.67/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/451.67/451.67-desktop-win8-win7-64bit-international-whql.exe) |
| GeForce | 451.74 Vulkan Beta | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/451.74/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/451.74/nvencodeapi.1337) |  |
| GeForce | 451.79 Vulkan Beta | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/451.79/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/451.79/nvencodeapi.1337) |  |
| GeForce | 451.98 Vulkan Beta | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/451.98/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/451.98/nvencodeapi.1337) |  |
| GeForce | 452.06 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/452.06/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/452.06/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/452.06/452.06-desktop-win8-win7-64bit-international-whql.exe) |
| GeForce | 452.28 Vulkan Beta | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/452.28/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/452.28/nvencodeapi.1337) |  |
| GeForce | 456.38 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/456.38/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/456.38/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/456.38/456.38-desktop-win8-win7-64bit-international-whql.exe) |
| GeForce | 456.55 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/456.55/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/456.55/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/456.55/456.55-desktop-win8-win7-64bit-international-whql.exe) |
| GeForce | 456.62 Vulkan Beta | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/456.62/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/456.62/nvencodeapi.1337) |  |
| GeForce | 456.71 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/456.71/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/456.71/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/456.71/456.71-desktop-win8-win7-64bit-international-whql.exe) |
| GeForce | 456.80 Vulkan Beta | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/456.80/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/456.80/nvencodeapi.1337) |  |
| GeForce | 457.09 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/457.09/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/457.09/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/457.09/457.09-desktop-win8-win7-64bit-international-whql.exe) |
| GeForce | 457.30 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/457.30/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/457.30/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/457.30/457.30-desktop-win8-win7-64bit-international-whql.exe) |
| GeForce | 457.33 Vulkan Beta | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/457.33/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/457.33/nvencodeapi.1337) |  |
| GeForce | 457.44 Vulkan Beta | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/457.44/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/457.44/nvencodeapi.1337) |  |
| GeForce | 457.51 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/457.51/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/457.51/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/457.51/457.51-desktop-win8-win7-64bit-international-whql.exe) |
| GeForce | 457.88 Vulkan Beta | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/457.88/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/457.88/nvencodeapi.1337) |  |
| GeForce | 457.91 Vulkan Beta | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/457.91/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/457.91/nvencodeapi.1337) |  |
| GeForce | 457.96 Vulkan Beta | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/457.96/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/457.96/nvencodeapi.1337) |  |
| GeForce | 460.79 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/460.79/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/460.79/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/460.79/460.79-desktop-win8-win7-64bit-international-whql.exe) |
| GeForce | 460.89 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/460.89/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/460.89/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/460.89/460.89-desktop-win8-win7-64bit-international-whql.exe) |
| GeForce | 461.09 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/461.09/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/461.09/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/461.09/461.09-desktop-win8-win7-64bit-international-whql.exe) |
| GeForce | 461.40 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/461.40/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/461.40/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/461.40/461.40-desktop-win8-win7-64bit-international-whql.exe) |
| GeForce | 461.72 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/461.72/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/461.72/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/461.72/461.72-desktop-win8-win7-64bit-international-whql.exe) |
| GeForce | 461.92 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/461.92/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/461.92/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/461.92/461.92-desktop-win8-win7-64bit-international-whql.exe) |
| GeForce | 465.89 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/465.89/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/465.89/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/465.89/465.89-desktop-win8-win7-64bit-international-whql.exe) |
| GeForce | 466.11 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/466.11/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/466.11/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/466.11/466.11-desktop-win8-win7-64bit-international-whql.exe) |
| GeForce | 466.27 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/466.27/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/466.27/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/466.27/466.27-desktop-win8-win7-64bit-international-whql.exe) |
| GeForce | 466.47 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/466.47/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/466.47/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/466.47/466.47-desktop-win8-win7-64bit-international-whql.exe) |
| GeForce | 466.63 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/466.63/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/466.63/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/466.63/466.63-desktop-win8-win7-64bit-international-whql.exe) |
| GeForce | 466.77 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/466.77/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/466.77/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/466.77/466.77-desktop-win8-win7-64bit-international-whql.exe) |
| GeForce | 471.11 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/471.11/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/471.11/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/471.11/471.11-desktop-win8-win7-64bit-international-whql.exe) |
| GeForce | 471.41 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/471.41/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/471.41/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/471.41/471.41-desktop-win8-win7-64bit-international-whql.exe) |
| GeForce | 471.68 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/471.68/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/471.68/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/471.68/471.68-desktop-win8-win7-64bit-international-whql.exe) |
| GeForce | 471.96 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/471.96/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/471.96/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/471.96/471.96-desktop-win8-win7-64bit-international-whql.exe) |
| GeForce | 472.12 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/472.12/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/472.12/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/472.12/472.12-desktop-win8-win7-64bit-international-whql.exe) |


| Product series | Version | x64 library patch | x86 library patch | Driver link |
|----------------|---------|-------------------|-------------------|-------------|
| Quadro | 431.02 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/quadro_431.02/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/quadro_431.02/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/Quadro_Certified/431.02/431.02-quadro-desktop-notebook-win8-win7-64bit-international-whql.exe) |
| Quadro | 431.70 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/quadro_431.70/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/quadro_431.70/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/Quadro_Certified/431.70/431.70-quadro-desktop-notebook-win8-win7-64bit-international-whql.exe) |
| Quadro | 431.86 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/quadro_431.86/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/quadro_431.86/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/Quadro_Certified/431.86/431.86-quadro-desktop-notebook-win8-win7-64bit-international-whql.exe) |
| Quadro | 431.94 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/quadro_431.94/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/quadro_431.94/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/Quadro_Certified/431.94/431.94-quadro-desktop-notebook-win8-win7-64bit-international-whql.exe) |
| Quadro | 436.02 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/quadro_436.02/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/quadro_436.02/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/Quadro_Certified/436.02/436.02-quadro-desktop-notebook-win8-win7-64bit-international-whql.exe) |
| Quadro | 436.30 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/quadro_436.30/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/quadro_436.30/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/Quadro_Certified/436.30/436.30-quadro-desktop-notebook-win8-win7-64bit-international-whql.exe) |
| Quadro | 440.97 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/quadro_440.97/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/quadro_440.97/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/Quadro_Certified/440.97/440.97-quadro-desktop-notebook-win8-win7-64bit-international-whql.exe) |
| Quadro | 441.12 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/quadro_441.12/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/quadro_441.12/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/Quadro_Certified/441.12/441.12-quadro-desktop-notebook-win8-win7-64bit-international-whql.exe) |
| Quadro | 441.28 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/quadro_441.28/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/quadro_441.28/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/Quadro_Certified/441.28/441.28-quadro-desktop-notebook-win8-win7-64bit-international-whql.exe) |
| Quadro | 441.66 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/quadro_441.66/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/win7_x64/quadro_441.66/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/Quadro_Certified/441.66/441.66-quadro-desktop-notebook-win8-win7-64bit-international-whql.exe) |


### Windows Server 2008R2, 2012, 2012R2 drivers


| Product series | Version | x64 library patch | x86 library patch | Driver link |
|----------------|---------|-------------------|-------------------|-------------|
| Quadro | 430.64 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/ws2012_x64/quadro_430.64/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/ws2012_x64/quadro_430.64/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/Quadro_Certified/430.64/430.64-quadro-winserv2008r2-2012-2012r2-64bit-international-whql.exe) |
| Quadro | 430.86 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/ws2012_x64/quadro_430.86/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/ws2012_x64/quadro_430.86/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/Quadro_Certified/430.86/430.86-quadro-winserv2008r2-2012-2012r2-64bit-international-whql.exe) |
| Quadro | 431.02 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/ws2012_x64/quadro_431.02/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/ws2012_x64/quadro_431.02/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/Quadro_Certified/431.02/431.02-quadro-winserv2008r2-2012-2012r2-64bit-international-whql.exe) |
| Quadro | 431.70 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/ws2012_x64/quadro_431.70/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/ws2012_x64/quadro_431.70/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/Quadro_Certified/431.70/431.70-quadro-winserv2008r2-2012-2012r2-64bit-international-whql.exe) |
| Quadro | 431.86 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/ws2012_x64/quadro_431.86/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/ws2012_x64/quadro_431.86/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/Quadro_Certified/431.86/431.86-quadro-winserv2008r2-2012-2012r2-64bit-international-whql.exe) |
| Quadro | 431.94 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/ws2012_x64/quadro_431.94/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/ws2012_x64/quadro_431.94/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/Quadro_Certified/431.94/431.94-quadro-winserv2008r2-2012-2012r2-64bit-international-whql.exe) |
| Quadro | 440.97 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/ws2012_x64/quadro_440.97/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/ws2012_x64/quadro_440.97/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/Quadro_Certified/440.97/440.97-quadro-winserv2008r2-2012-2012r2-64bit-international-whql.exe) |
| Quadro | 441.12 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/ws2012_x64/quadro_441.12/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/ws2012_x64/quadro_441.12/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/Quadro_Certified/441.12/441.12-quadro-winserv2008r2-2012-2012r2-64bit-international-whql.exe) |
| Quadro | 441.28 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/ws2012_x64/quadro_441.28/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/ws2012_x64/quadro_441.28/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/Quadro_Certified/441.28/441.28-quadro-winserv2008r2-2012-2012r2-64bit-international-whql.exe) |
| Quadro | 441.66 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/ws2012_x64/quadro_441.66/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/ws2012_x64/quadro_441.66/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/Quadro_Certified/441.66/441.66-quadro-winserv2008r2-2012-2012r2-64bit-international-whql.exe) |
| Quadro | 442.19 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/ws2012_x64/quadro_442.19/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/ws2012_x64/quadro_442.19/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/Quadro_Certified/442.19/442.19-quadro-winserv-2012r2-64bit-international-whql.exe) |
| Quadro | 442.50 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/ws2012_x64/quadro_442.50/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/ws2012_x64/quadro_442.50/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/Quadro_Certified/442.50/442.50-quadro-winserv-2012r2-64bit-international-whql.exe) |
| Quadro | 442.74 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/ws2012_x64/quadro_442.74/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/ws2012_x64/quadro_442.74/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/Quadro_Certified/442.74/442.74-quadro-winserv-2012r2-64bit-international-whql.exe) |
| Quadro | 442.92 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/ws2012_x64/quadro_442.92/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/ws2012_x64/quadro_442.92/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/Quadro_Certified/442.92/442.92-quadro-winserv-2012r2-64bit-international-whql.exe) |
| Quadro | 451.48 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/ws2012_x64/quadro_451.48/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/ws2012_x64/quadro_451.48/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/Quadro_Certified/451.48/451.48-quadro-winserv-2012r2-64bit-international-whql.exe) |
| Quadro | 452.06 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/ws2012_x64/quadro_452.06/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/ws2012_x64/quadro_452.06/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/Quadro_Certified/452.06/452.06-quadro-winserv-2012r2-64bit-international-whql.exe) |
| Quadro | 452.39 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/ws2012_x64/quadro_452.39/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/ws2012_x64/quadro_452.39/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/Quadro_Certified/452.39/452.39-quadro-winserv-2012r2-64bit-international-whql.exe) |
| Quadro | 452.57 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/ws2012_x64/quadro_452.57/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/ws2012_x64/quadro_452.57/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/Quadro_Certified/452.57/452.57-quadro-winserv-2012r2-64bit-international-whql.exe) |
| Quadro | 460.89 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/ws2012_x64/quadro_460.89/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/ws2012_x64/quadro_460.89/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/Quadro_Certified/460.89/460.89-quadro-rtx-winserv-2012r2-64bit-international-whql.exe) |
| Quadro | 461.09 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/ws2012_x64/quadro_461.09/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/ws2012_x64/quadro_461.09/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/Quadro_Certified/461.09/461.09-quadro-rtx-winserv-2012r2-64bit-international-whql.exe) |
| Quadro | 461.40 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/ws2012_x64/quadro_461.40/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/ws2012_x64/quadro_461.40/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/Quadro_Certified/461.40/461.40-quadro-rtx-winserv-2012r2-64bit-international-whql.exe) |
| Quadro | 461.72 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/ws2012_x64/quadro_461.72/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/ws2012_x64/quadro_461.72/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/Quadro_Certified/461.72/461.72-quadro-rtx-winserv-2012r2-64bit-international-whql.exe) |
| Quadro | 461.92 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/ws2012_x64/quadro_461.92/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/ws2012_x64/quadro_461.92/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/Quadro_Certified/461.92/461.92-quadro-rtx-winserv-2012r2-64bit-international-whql.exe) |
| Quadro | 462.31 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/ws2012_x64/quadro_462.31/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/ws2012_x64/quadro_462.31/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/Quadro_Certified/462.31/462.31-quadro-rtx-winserv-2012r2-64bit-international-whql.exe) |
| Quadro | 462.59 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/ws2012_x64/quadro_462.59/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/ws2012_x64/quadro_462.59/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/Quadro_Certified/462.59/462.59-quadro-rtx-winserv-2012r2-64bit-international-whql.exe) |
| Quadro | 462.96 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/ws2012_x64/quadro_462.96/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/ws2012_x64/quadro_462.96/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/Quadro_Certified/462.96/462.96-quadro-rtx-winserv-2012r2-64bit-international-whql.exe) |
| Quadro | 471.11 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/ws2012_x64/quadro_471.11/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/ws2012_x64/quadro_471.11/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/Quadro_Certified/471.11/471.11-quadro-rtx-winserv-2012r2-64bit-international-whql.exe) |
| Quadro | 471.41 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/ws2012_x64/quadro_471.41/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/ws2012_x64/quadro_471.41/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/Quadro_Certified/471.41/471.41-quadro-rtx-winserv-2012r2-64bit-international-whql.exe) |
| Quadro | 471.68 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/ws2012_x64/quadro_471.68/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/ws2012_x64/quadro_471.68/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/Quadro_Certified/471.68/471.68-quadro-rtx-winserv-2012r2-64bit-international-whql.exe) |
| Quadro | 472.12 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/ws2012_x64/quadro_472.12/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/ws2012_x64/quadro_472.12/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/Quadro_Certified/472.12/472.12-quadro-rtx-winserv-2012r2-64bit-international-whql.exe) |
| Quadro | 472.84 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/ws2012_x64/quadro_472.84/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/ws2012_x64/quadro_472.84/nvencodeapi.1337) | [Driver link](http://international.download.nvidia.com/Windows/Quadro_Certified/472.84/472.84-quadro-rtx-winserv-2012r2-64bit-international-whql.exe) |


### Windows Server 2016, 2019 drivers


| Product series | Version | x64 library patch | x86 library patch | Driver link |
|----------------|---------|-------------------|-------------------|-------------|
| Quadro | 430.86 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/ws2016_x64/quadro_430.86/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/ws2016_x64/quadro_430.86/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/Quadro_Certified/430.86/430.86-quadro-winserv-2016-2019-64bit-international-whql.exe) |
| Quadro | 431.02 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/ws2016_x64/quadro_431.02/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/ws2016_x64/quadro_431.02/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/Quadro_Certified/431.02/431.02-quadro-winserv-2016-2019-64bit-international-whql.exe) |
| Quadro | 431.70 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/ws2016_x64/quadro_431.70/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/ws2016_x64/quadro_431.70/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/Quadro_Certified/431.70/431.70-quadro-winserv-2016-2019-64bit-international-whql.exe) |
| Quadro | 431.86 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/ws2016_x64/quadro_431.86/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/ws2016_x64/quadro_431.86/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/Quadro_Certified/431.86/431.86-quadro-winserv-2016-2019-64bit-international-whql.exe) |
| Quadro | 431.94 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/ws2016_x64/quadro_431.94/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/ws2016_x64/quadro_431.94/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/Quadro_Certified/431.94/431.94-quadro-winserv-2016-2019-64bit-international-whql.exe) |
| Quadro | 440.97 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/ws2016_x64/quadro_440.97/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/ws2016_x64/quadro_440.97/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/Quadro_Certified/440.97/440.97-quadro-winserv-2016-2019-64bit-international-whql.exe) |
| Quadro | 441.12 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/ws2016_x64/quadro_441.12/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/ws2016_x64/quadro_441.12/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/Quadro_Certified/441.12/441.12-quadro-winserv-2016-2019-64bit-international-whql.exe) |
| Quadro | 441.28 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/ws2016_x64/quadro_441.28/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/ws2016_x64/quadro_441.28/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/Quadro_Certified/441.28/441.28-quadro-winserv-2016-2019-64bit-international-whql.exe) |
| Quadro | 441.66 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/ws2016_x64/quadro_441.66/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/ws2016_x64/quadro_441.66/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/Quadro_Certified/441.66/441.66-quadro-winserv-2016-2019-64bit-international-whql.exe) |
| Quadro | 442.19 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/ws2016_x64/quadro_442.19/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/ws2016_x64/quadro_442.19/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/Quadro_Certified/442.19/442.19-quadro-winserv-2016-2019-64bit-international-whql.exe) |
| Quadro | 442.50 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/ws2016_x64/quadro_442.50/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/ws2016_x64/quadro_442.50/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/Quadro_Certified/442.50/442.50-quadro-winserv-2016-2019-64bit-international-whql.exe) |
| Quadro | 442.74 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/ws2016_x64/quadro_442.74/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/ws2016_x64/quadro_442.74/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/Quadro_Certified/442.74/442.74-quadro-winserv-2016-2019-64bit-international-whql.exe) |
| Quadro | 442.92 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/ws2016_x64/quadro_442.92/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/ws2016_x64/quadro_442.92/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/Quadro_Certified/442.92/442.92-quadro-winserv-2016-2019-64bit-international-whql.exe) |
| Quadro | 451.48 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/ws2016_x64/quadro_451.48/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/ws2016_x64/quadro_451.48/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/Quadro_Certified/451.48/451.48-quadro-winserv-2016-2019-64bit-international-whql.exe) |
| Quadro | 452.06 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/ws2016_x64/quadro_452.06/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/ws2016_x64/quadro_452.06/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/Quadro_Certified/452.06/452.06-quadro-winserv-2016-2019-64bit-international-whql.exe) |
| Quadro | 452.39 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/ws2016_x64/quadro_452.39/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/ws2016_x64/quadro_452.39/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/Quadro_Certified/452.39/452.39-quadro-winserv-2016-2019-64bit-international-whql.exe) |
| Quadro | 452.57 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/ws2016_x64/quadro_452.57/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/ws2016_x64/quadro_452.57/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/Quadro_Certified/452.57/452.57-quadro-winserv-2016-2019-64bit-international-whql.exe) |
| Quadro | 460.89 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/ws2016_x64/quadro_460.89/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/ws2016_x64/quadro_460.89/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/Quadro_Certified/460.89/460.89-quadro-rtx-winserv-2016-2019-64bit-international-whql.exe) |
| Quadro | 461.09 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/ws2016_x64/quadro_461.09/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/ws2016_x64/quadro_461.09/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/Quadro_Certified/461.09/461.09-quadro-rtx-winserv-2016-2019-64bit-international-whql.exe) |
| Quadro | 461.40 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/ws2016_x64/quadro_461.40/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/ws2016_x64/quadro_461.40/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/Quadro_Certified/461.40/461.40-quadro-rtx-winserv-2016-2019-64bit-international-whql.exe) |
| Quadro | 461.72 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/ws2016_x64/quadro_461.72/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/ws2016_x64/quadro_461.72/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/Quadro_Certified/461.72/461.72-quadro-rtx-winserv-2016-2019-64bit-international-whql.exe) |
| Quadro | 461.92 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/ws2016_x64/quadro_461.92/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/ws2016_x64/quadro_461.92/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/Quadro_Certified/461.92/461.92-quadro-rtx-winserv-2016-2019-64bit-international-whql.exe) |
| Quadro | 462.31 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/ws2016_x64/quadro_462.31/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/ws2016_x64/quadro_462.31/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/Quadro_Certified/462.31/462.31-quadro-rtx-winserv-2016-2019-64bit-international-whql.exe) |
| Quadro | 462.59 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/ws2016_x64/quadro_462.59/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/ws2016_x64/quadro_462.59/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/Quadro_Certified/462.59/462.59-quadro-rtx-winserv-2016-2019-64bit-international-whql.exe) |
| Quadro | 462.96 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/ws2016_x64/quadro_462.96/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/ws2016_x64/quadro_462.96/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/Quadro_Certified/462.96/462.96-quadro-rtx-winserv-2016-2019-64bit-international-whql.exe) |
| Quadro | 471.11 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/ws2016_x64/quadro_471.11/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/ws2016_x64/quadro_471.11/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/Quadro_Certified/471.11/471.11-quadro-rtx-winserv-2016-2019-64bit-international-whql.exe) |
| Quadro | 471.41 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/ws2016_x64/quadro_471.41/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/ws2016_x64/quadro_471.41/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/Quadro_Certified/471.41/471.41-quadro-rtx-winserv-2016-2019-64bit-international-whql.exe) |
| Quadro | 471.68 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/ws2016_x64/quadro_471.68/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/ws2016_x64/quadro_471.68/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/Quadro_Certified/471.68/471.68-quadro-rtx-winserv-2016-2019-64bit-international-whql.exe) |
| Quadro | 472.12 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/ws2016_x64/quadro_472.12/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/ws2016_x64/quadro_472.12/nvencodeapi.1337) | [Driver link](https://international.download.nvidia.com/Windows/Quadro_Certified/472.12/472.12-quadro-rtx-winserv-2016-2019-64bit-international-whql.exe) |
| Quadro | 472.84 | [x64 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/ws2016_x64/quadro_472.84/nvencodeapi64.1337) | [x86 library patch](https://raw.githubusercontent.com/keylase/nvidia-patch/master/win/ws2016_x64/quadro_472.84/nvencodeapi.1337) | [Driver link](http://international.download.nvidia.com/Windows/Quadro_Certified/472.84/472.84-quadro-rtx-winserv-2016-2019-64bit-international-whql.exe) |


## Benchmarks

* [Plex Media Server: nVidia Hardware Transcoding Calculator for Plex Estimates](https://www.elpamsoft.com/?p=Plex-Hardware-Transcoding) - useful benchmark of achieved simultaneous transcodes with various stream quality and hardware with patched drivers.
