Basic RADIUS Server for node.js for Google LDAP Service and WPA2 Enteprise WLAN Authentification.

- supports LDAP Authentification Backend
- supports WPA2 Entprise (TTLS over PAP)

Protect your WIFI access with a username and password by a credential provider you already use!

Authenticiation tested with Windows, Linux, Android and Apple devices.

# Quick start

1. Install nightly node js
    - easiest way is to install a node js version from nodejs.org and run "npx n nightly" to install nightly version.
2. Check out the config options, e.g. for google ldap, download your certificates from http://admin.google.com/ -> Apps -> LDAP -> Client
download the files and name them "ldap.gsuite.key" and "ldap.gsuite.crt" accordingly.
3. Switch to this directory and run "npx radius-server -s YourRadiusSecret"
4. Log into your WLAN Controller and configure the radius server to your newly running radius
5. On your clients, just connect to the WLAN, the clients should figure out the correct method by their own,
if they don't use: WPA2-Enterprise -> EAP-TTLS -> PAP / CHAP
6. Log in via your google credentials (email + password, ... e.g. youremail@yourcompany.com)

## Known Issues / Disclaimer

This is a first implementation, which is currently only working with node js nightly (node 13+) (see https://github.com/nodejs/node/pull/31814).

- MD5 Challenge not implenented, but RFC says this is mandatory ;-)
- Inner Tunnel does not act differently, even though spec says that EAP-message are not allowed to get fragmented,
this is not a problem right now, as the messages of the inner tunnel are small enough, but it could be a bug in the future.
ways to approach this: refactor that the inner tunnel can set max fragment size, or rebuild eap fragments in ttls after inner tunnel response

CONTRIBUTIONS WELCOME! If you are willing to help, just open a PR or contact me via bug system or simon.tretter@hokify.com.

## Motivation

### Why not Freeradius?

There are several reasons why I started implementing this radius server in node js. We are using
freeradius right now, but have several issues which are hard to tackle due to the reason that freeradius
is a complex software and supports many uses cases. It is also written in C++ and uses threads behind the scene.
Therefore it's not easy to extend or modify it, or even bring new feature in.
The idea of this project is to make a super simple node radius server, which is async by default. No complex
thread handling, no other fancy thing. The basic goal is to make WPA2 authenticiation easy again.

### 802.1x protocol in node

Another motivation is that it is very exciting to see how wireless protocols have evolved, and see
how a implementation like TTLS works.

### Few alternatives (only non-free ones like Jumpcloud...)

Furthermore there are few alternatives out there, e.g. jumpcloud is non-free and I couldn't find many others.

### Vision

As soon as I understood the TTLS PAP Tunnel approach, I had this vision of making Wlan Authentification easy
for everyone. Why limit it to something "complex" like LDAP and co. This library aims to make it easy for everyone
to implement either their own authentication mechanismus (e.g. against a database), or provides some mechansimns
out of the box (e.g. imap, static, ldap,..).

## Installation

    npm install
    npm run build

## Introduction

This app provides a radius server to authenticate against google's SLDAP service. To get this running
you need:

1.  Running LDAP Service (E.g. Google Suite Enterprise or Gloud Identity Premium)
2.  Optional: Create your own SSL certificate (e.g. self signed via npm run create-certificate)
3.  Check config.js and adapt to your needs

- configure authentication:
  set authenticaiton to one of the provided authenticators.

```js
var config = {
	// ....
	authentication: 'GoogleLDAPAuth',
	authenticationOptions: {
		base: 'dc=hokify,dc=com'
	}
};
```

- set radius secret

4.  Install und build server: npm install && npm run build
5.  Start server "npm run start"

## Configuration

see config.js in root

### Authentications

#### Google LDAP

google ldap optimized authenticiation implementaiton

```typescript
interface IGoogleLDAPAuthOptions {
	/** base DN
	 *  e.g. 'dc=hokify,dc=com', */
	base: string;
	/** tls options
	 * e.g. {
			key: fs.readFileSync('ldap.gsuite.key'),
			cert: fs.readFileSync('ldap.gsuite.crt')
		} */
	tlsOptions: tls.TlsOptions;
}
```

Example

```js
c = {
	// GoogleLDAPAuth (optimized for google auth)
	authentication: 'GoogleLDAPAuth',
	authenticationOptions: {
		base: 'dc=hokify,dc=com',
		tlsOptions: {
			key: fs.readFileSync('ldap.gsuite.key'),
			cert: fs.readFileSync('ldap.gsuite.crt')
		}
	}
};
```

#### LDAP

ldap authentication

```typescript
interface ILDAPAuthOptions {
	/** ldap url
	 * e.g. ldaps://ldap.google.com
	 */
	url: string;
	/** base DN
	 *  e.g. 'dc=hokify,dc=com', */
	base: string;
	/** tls options
	 * e.g. {
			key: fs.readFileSync('ldap.gsuite.key'),
			cert: fs.readFileSync('ldap.gsuite.crt'),
			servername: 'ldap.google.com'
		} */
	tlsOptions?: any;
	/**
	 * searchFilter
	 */
	searchFilter?: string;
}
```

Example

```js
c = {
	authentication: 'LDAPAuth',
	authenticationOptions: {
		url: 'ldaps://ldap.google.com',
		base: 'dc=hokify,dc=com',
		tlsOptions: {
			key: fs.readFileSync('ldap.gsuite.key'),
			cert: fs.readFileSync('ldap.gsuite.crt'),
			servername: 'ldap.google.com'
		}
	}
};
```

#### IMAP

imap authenticiation

```typescript
interface IIMAPAuthOptions {
	host: string;
	port?: number;
	useSecureTransport?: boolean;
	validHosts?: string[];
}
```

Example

```js
c = {
	authentication: 'IMAPAuth',
	authenticationOptions: {
		host: 'imap.gmail.com',
		port: 993,
		useSecureTransport: true,
		validHosts: ['hokify.com']
	}
};
```

#### SMTP

smtp authenticiation

```typescript
interface ISMTPAuthOptions {
	host: string;
	port?: number;
	useSecureTransport?: boolean;
	validHosts?: string[];
}
```

Example

```js
c = {
	authentication: 'IMAPAuth',
	authenticationOptions: {
		host: 'smtp.gmail.com',
		port: 465,
		useSecureTransport: true,
		validHosts: ['gmail.com']
	}
};
```

#### Static Auth

static authenticiation

```typescript
interface IStaticAuthOtions {
	validCrentials: {
		username: string;
		password: string;
	}[];
}
```

Example

```js
c = {
	authentication: 'StaticAuth',
	authenticationOptions: {
		validCredentials: [
			{ username: 'test', password: 'pwd' },
			{ username: 'user1', password: 'password' },
			{ username: 'admin', password: 'cool' }
		]
	}
};
```

## Usage

Ensure you have installed latest nightly node version and run:

    npm run start
