#!/bin/sh
set -e

NGINX_CONF_PATH="${NGINX_CONF_PATH:-/etc/nginx/nginx.conf}"

node dist

# 检查是否需要 ACME
if grep -q 'acme_required' "$NGINX_CONF_PATH"; then
  echo "[entrypoint] ACME required detected, scheduling daily renewCert task" >&2
  (
    while true; do
      sleep 86400  # 24h
      echo "[entrypoint] Running daily cert renewal..." >&2
      if ! node dist renewCert; then
        echo "[entrypoint] renewCert failed" >&2
      fi
      echo "[entrypoint] Daily cert renewal finished." >&2
    done
  ) &
fi

exec "$@"
