export class Parser {
  constructor(
    private prefix: string,
    private input: Record<string, string> = process.env,
  ) {}

  getString(key: string) {
    return this.input[`${this.prefix}${key}`];
  }

  getNumber(key: string) {
    const value = this.getString(key);
    if (!value) {
      return undefined;
    }
    return parseFloat(value);
  }

  getBoolean(key: string) {
    const value = this.getString(key);
    if (!value) {
      return false;
    }
    return value !== 'false' && value !== '0';
  }

  getDict(key: string) {
    const prefix = `${this.prefix}${key}_`;
    const keys = Object.keys(this.input).filter((k) => k.startsWith(prefix));
    const dict: Record<string, string> = {};
    for (const k of keys) {
      dict[k.slice(prefix.length)] = this.input[k];
    }
    return dict;
  }

  getArray(key: string) {
    let dictValue = Object.values(this.getDict(key));
    const directValue = this.getString(key);
    if (directValue) {
      dictValue = dictValue.concat(directValue.split(','));
    }
    if (!dictValue.length) {
      return;
    }
    return dictValue;
  }

  getArrayNumber(key: string) {
    return this.getArray(key)?.map((v) => parseFloat(v));
  }
}
