# nginx-proxy

Nginx with only env var conf.

## Variables

### Site

Site variables should be followed after `SITE_<domain>_`.

- `SITE_mycard.moe` Site and origin. eg. `SITE_mycard.moe=http://localhost:3000`
- `HTTPS` Enable HTTPS and specify cert.
- `HTTPS_NOREDIR` Disable redirect to HTTPS.
- `HSTS` Enable HSTS.
- `HEADER` Extra header. eg. `SITE_mycard.moe_HEADER_FOO=bar`
- `DISABLE_TOP` Disable / access.
- `HTPASSWD_username` Enable basic auth, and specify username and password.
- `CORS` Enable CORS.
- `SERVER_EXTRA` Extra entry in `server`.
- `LOCATION_EXTRA` Extra entry in `location`.

#### Proxy

Use `SITE_mycard.moe: http://localhost:3000`.

- `MINIO` Enable minio mode.
- `NO_VERIFY_CERTS` Disable origina cert verification.
- `NO_BUFFER` Add `proxy_buffering off;` to nginx conf.
- `NO_CACHE` Add `proxy_cache off;` to nginx conf.
- `SNI` Add `proxy_ssl_server_name on;` to nginx conf.
- `TIMEOUT` in seconds.

#### Static

Use `SITE_mycard.moe: static:///path/to/site`.

- `INDEX` Specify index file. Default `index.html`.
- `EXPIRES` Specify expires time. Default `10m`.
- `BROWSE` Enable directory browsing.

#### PHP

Use `SITE_mycard.moe: php://fpm.example.com:9000/path/to/site`.

- `INDEX` Specify index file. Default `index.php`.
- `EXPIRES` Specify expires time. Default `10m`.
- `PHP_EXTRA` Extra entry in `location`.

#### Redirect

Use `SITE_mycard.moe: redirect+https://example.com`.

- `CODE` Specify redirect code. Default `301`.

### Global

- `PURGE_ALLOWED` IPs allowed to do PURGE request.
- `REAL_IP` IPs allowed to send `X-Forwarded-For` header.
- `EXTERNAL_REAL_IP` Don't set any real IP options, as they would be set from `conf.d` dir.
- `LIMIT_RATE` `LIMIT_BURST` `MAX_CACHE_SIZE` in original format. eg. `LIMIT_RATE=10m`
- `HTTP_EXTRA` Extra entry in `http` section.
- `NGINX_EXTRA` Extra entry in `nginx.conf` section.
- `HTTP_EXTRA_PRE` Extra entry in `http` section, before every sites.
- `NGINX_EXTRA_PRE` Extra entry in `nginx.conf` section, before `http` section.
