import { MiddlewareNext } from '../middleware-dispatcher';
import { Awaitable } from '../types';

export type I18nMiddlewareFunc<Ex extends any[] = []> = (
  locale: string,
  text: string,
  ...ex: Ex
) => string | undefined;

export type I18nMiddlewareNext<Ex extends any[] = []> = MiddlewareNext<
  I18nMiddlewareFunc<Ex>
>;

export type I18nMiddleware<Ex extends any[] = []> = (
  locale: string,
  text: string,
  next: I18nMiddlewareNext<Ex>,
  ...ex: Ex
) => Awaitable<string | undefined>;

export interface I18nOptions {
  locales: string[];
  defaultLocale?: string;
}
