export class RoundRobin<T> {
  private index = 0;

  constructor(public items: T[]) {
    if (items.length === 0) {
      throw new Error('RoundRobin requires at least one item');
    }
  }

  next(): T {
    const nextIndex = this.index % this.items.length;
    this.index = (this.index + 1) % this.items.length;
    return this.items[nextIndex];
  }
}
