import {
  AnyFunc,
  MiddlewareDispatcherOptions,
  Middleware,
  MiddlewareResult,
  MiddlewareAcceptResult,
  MiddlewareErrorHandler,
  MiddlewareReturn,
  MiddlewareNextArgs,
} from './types';

export class DynamicMiddlewareDispatcher<F extends AnyFunc> {
  constructor(protected options: MiddlewareDispatcherOptions<F> = {}) {}

  async buildMiddlewares(...args: Parameters<F>): Promise<Middleware<F>[]> {
    return [];
  }

  async dispatch(...args: Parameters<F>): MiddlewareResult<F> {
    const mws = await this.buildMiddlewares(...args);
    const acceptResult: MiddlewareAcceptResult<F> =
      this.options.acceptResult || ((res) => res != null);
    const errorHandler: MiddlewareErrorHandler<F> =
      this.options.errorHandler || ((e, args, next) => next());
    const dispatch = async (
      i: number,
      useArgs: Parameters<F>,
    ): MiddlewareResult<F> => {
      if (i >= mws.length) return undefined;

      const mw = mws[i];
      let nextCalled = false;

      const next = async (
        ...passedArgs: MiddlewareNextArgs<F>
      ): MiddlewareResult<F> => {
        if (nextCalled) {
          return undefined;
        }
        nextCalled = true;
        return dispatch(i + 1, [
          ...passedArgs,
          ...useArgs.slice(passedArgs.length),
        ] as Parameters<F>);
      };

      const runMw = async (cb: () => MiddlewareReturn<F>) => {
        const res = await cb();
        if (!nextCalled && !(await acceptResult(res))) {
          return dispatch(i + 1, useArgs);
        }
        return res;
      };

      try {
        return await runMw(() => mw(...useArgs, next));
      } catch (e) {
        return await runMw(() => errorHandler(e, useArgs, next));
      }
    };
    return dispatch(0, args);
  }
}
