export const Memorize = () => {
  const cache = new WeakMap<object, any>();

  const isPromiseLike = (v: any): v is Promise<unknown> =>
    v != null && typeof v.then === 'function' && typeof v.catch === 'function';

  const getOrSet = (instance: object, compute: () => any) => {
    if (cache.has(instance)) return cache.get(instance);

    const result = compute();

    if (isPromiseLike(result)) {
      const wrapped = result.catch((err) => {
        cache.delete(instance); // 下次还能重新算
        throw err;
      });
      cache.set(instance, wrapped);
      return wrapped;
    }

    cache.set(instance, result);
    return result;
  };

  return function (
    _target: any,
    _propertyKey: string,
    descriptor: PropertyDescriptor,
  ) {
    // getter
    if (typeof descriptor.get === 'function') {
      const originalGetter = descriptor.get;
      descriptor.get = function () {
        return getOrSet(this, () => originalGetter.call(this));
      };
      return;
    }

    // method
    if (typeof descriptor.value === 'function') {
      const originalMethod = descriptor.value;
      descriptor.value = function (...args: any[]) {
        return getOrSet(this, () => originalMethod.apply(this, args));
      };
      return;
    }
  };
};
