import { workflow } from '../src/workflow';
import { dualizeAny } from '../src/dual-object';

describe('dualizeAny + workflow', () => {
  test('workflow over dualizeAny works correctly', async () => {
    const obj = dualizeAny(
      () => {
        return {
          id: 'local',
          name: () => 'cached',
          ping: async () => 1,
        };
      },
      async () => {
        await new Promise((r) => setTimeout(r, 30));
        return {
          id: 'remote',
          name: () => 'fresh',
          ping: async () => 42,
        };
      },
      { asyncMethods: ['ping'] as const },
    );

    const wf = workflow(obj);

    // Should be async property access
    const name1 = await wf.name();
    expect(name1).toBe('fresh');

    // Now call async method
    const pingResult = await wf.ping();
    expect(pingResult).toBe(42);

    // Finally, await the whole object
    const finalObj = await wf;
    expect(finalObj.id).toBe('remote');
  });
});
