import { abortable } from '../src/abortable';

describe('abortable() - falsy truthiness 行为', () => {
  test('默认（不装箱）: 所有原始 falsy 仍为 falsy', () => {
    const ac = new AbortController();
    const s = ac.signal;

    const cases: any[] = [false, 0, -0, 0n, '', null, undefined, NaN];

    for (const v of cases) {
      const wrapped = abortable(v, s); // 默认 boxPrimitives=false
      expect(Boolean(wrapped)).toBe(false);
    }
  });

  test('负例说明：开启 boxPrimitives=true 会把原始值装箱为对象（变成 truthy）', () => {
    const ac = new AbortController();
    const s = ac.signal;

    const cases: any[] = [false, 0, -0, 0n, '', null, undefined, NaN];

    for (const v of cases) {
      const wrapped = abortable(v, s, { boxPrimitives: true });
      // 被装箱后成为对象（或 {}），对象的 truthiness 恒为 true
      expect(Boolean(wrapped)).toBe(true);
    }

    // 非原始值（对象/数组/函数）无论是否装箱，本来就是 truthy
    const obj = {};
    expect(Boolean(abortable(obj, s))).toBe(true);
    expect(Boolean(abortable(obj, s, { boxPrimitives: true }))).toBe(true);
  });
});
