import { Awaitable } from '../types';

export type AnyFunc = (...args: any[]) => any;

export type MiddlewareValue<F extends AnyFunc> = Awaited<ReturnType<F>>;
export type MiddlewareResult<F extends AnyFunc> = Promise<MiddlewareValue<F>>;

type StaircaseParams<A extends any[]> = A extends []
  ? []
  : A extends [...infer Rest, any]
    ? A | StaircaseParams<Rest>
    : never;

export type MiddlewareNextArgs<F extends AnyFunc> =
  | StaircaseParams<Parameters<F>>
  | [];
export type MiddlewareNext<F extends AnyFunc> = (
  ...args: MiddlewareNextArgs<F>
) => MiddlewareResult<F>;
export type MiddlewareArgs<F extends AnyFunc> = [
  ...args: Parameters<F>,
  next: MiddlewareNext<F>,
];
export type MiddlewareReturn<F extends AnyFunc> = Awaitable<MiddlewareValue<F>>;

export type Middleware<F extends AnyFunc> = (
  ...args: MiddlewareArgs<F>
) => MiddlewareReturn<F>;

export type MiddlewareAcceptResult<F extends AnyFunc> = (
  s: MiddlewareValue<F>,
) => Awaitable<boolean>;
export type MiddlewareErrorHandler<F extends AnyFunc> = (
  e: any,
  args: Parameters<F>,
  next: MiddlewareNext<F>,
) => Awaitable<MiddlewareValue<F>>;

export interface MiddlewareDispatcherOptions<F extends AnyFunc> {
  acceptResult?: MiddlewareAcceptResult<F>;
  errorHandler?: MiddlewareErrorHandler<F>;
}
