import { AnyFunc, Middleware } from './types';
import { DynamicMiddlewareDispatcher } from './dynamic-middleware-dispatcher';

export class MiddlewareDispatcher<
  F extends AnyFunc,
> extends DynamicMiddlewareDispatcher<F> {
  middlewares: Middleware<F>[] = [];

  middleware(mw: Middleware<F>, prior = false) {
    if (prior) {
      this.middlewares.unshift(mw);
    } else {
      this.middlewares.push(mw);
    }
    return this;
  }

  removeMiddleware(mw: Middleware<F>) {
    const index = this.middlewares.indexOf(mw);
    if (index >= 0) {
      this.middlewares.splice(index, 1);
    }
    return this;
  }

  async buildMiddlewares(...args: Parameters<F>): Promise<Middleware<F>[]> {
    return this.middlewares;
  }
}
