import { Awaitable, Empty, Prettify } from '../types';
import { AppContextCore } from './app-context';

type CurAndReq<Cur, Req> = {
  [K in keyof Cur | keyof Req]: K extends keyof Cur
    ? Cur[K]
    : K extends keyof Req
      ? Req[K]
      : never;
};

export type AppContext<Cur = Empty, Req = Empty> = AppContextCore<Cur, Req> &
  CurAndReq<Cur, Req>;

export type AppServiceClass<
  Cur = Empty,
  Req = Empty,
  A extends any[] = any[],
  R = any,
> = new (ctx: AppContext<CurAndReq<Cur, Req>>, ...args: A) => R;

export type AppServiceConfig<C extends AppServiceClass> = C extends new (
  first: any,
  ...args: infer A
) => any
  ? A
  : never;

export type AppProvideOptions<
  Cur,
  Req,
  C extends AppServiceClass<Cur, Req>,
  P extends string,
  M extends (keyof InstanceType<C>)[],
> = {
  provide?: P;
  merge?: M;
  useValue?: Awaitable<InstanceType<C>>;
  useFactory?: (
    ctx: AppContext<Cur, Req>,
    ...args: ConstructorParameters<C>
  ) => Awaitable<InstanceType<C>>;
  useClass?: new (...args: ConstructorParameters<C>) => InstanceType<C>;
};

export type AppProvideArgs<
  Cur,
  Req,
  C extends AppServiceClass<Cur, Req>,
  P extends string,
  M extends (keyof InstanceType<C>)[],
> = [
  ...args: AppServiceConfig<C>,
  options?: AppProvideOptions<Cur, Req, C, P, M>,
];

type CurResolved<Cur, Req, Cur2, Req2> = Prettify<Cur & Cur2>;
type ResolveReq<Provided, Req> = {
  [K in keyof Req as K extends keyof Provided
    ? Provided[K] extends Req[K]
      ? never // ✅ 满足 → 删除
      : K // ❌ 类型不匹配 → 保留
    : K]: Req[K]; // ❌ 没提供 → 保留
};
type ReqResolved<Cur, Req, Cur2, Req2> = Prettify<
  ResolveReq<Cur & Cur2, Req & Req2>
>;

type AppContextResolved<Cur, Req, Cur2, Req2> = AppContext<
  CurResolved<Cur, Req, Cur2, Req2>,
  ReqResolved<Cur, Req, Cur2, Req2>
>;

export type AppProvidedMerged<
  Cur,
  Req,
  C extends AppServiceClass<any, any>,
  P extends string,
  M extends (keyof InstanceType<C>)[],
> = AppContextResolved<
  Cur,
  Req,
  {
    [K in M[number]]: InstanceType<C>[K];
  } & (P extends '' ? Empty : { [K in P]: InstanceType<C> }),
  Empty
>;

export type AppContextUsed<
  Cur,
  Req,
  Ctxes extends AppContext<any, any>[],
> = Ctxes extends []
  ? AppContext<Cur, Req>
  : Ctxes extends [infer First, ...infer Rest extends AppContext<any, any>[]]
    ? First extends AppContext<infer Cur2, infer Req2>
      ? AppContextUsed<
          CurResolved<Cur, Req, Cur2, Req2>,
          ReqResolved<Cur, Req, Cur2, Req2>,
          Rest
        >
      : never
    : never;
