const leb = {
  encode: (value) => {
    value |= 0;
    const result = [];
    while (true) {
      const byte = value & 0x7f;
      value >>= 7;
      if (
        (value === 0 && (byte & 0x40) === 0) ||
        (value === -1 && (byte & 0x40) !== 0)
      ) {
        result.push(byte);
        return Buffer.from(result);
      }
      result.push(byte | 0x80);
    }
  },
  decode: (input) => {
    let result = 0;
    let shift = 0;
    while (true) {
      const byte = input.shift();
      result |= (byte & 0x7f) << shift;
      shift += 7;
      if ((0x80 & byte) === 0) {
        if (shift < 32 && (byte & 0x40) !== 0) {
          return result | (~0 << shift);
        }
        return result;
      }
    }
  },
};

export const parsePacket = {
  hostname: (buffer: Buffer) => {
    const val1 = 3;
    const val2 =
      buffer.indexOf(0x00) == -1 ? buffer.length - 3 : buffer.indexOf(0x00) - 4;

    const result = buffer.slice(val1, val2).toString('utf8');

    return result;
  },
  port: (buffer: Buffer) => {
    const val1 =
      buffer.indexOf(0x00) == -1 ? buffer.length - 3 : buffer.indexOf(0x00) - 4;
    const val2 =
      buffer.indexOf(0x00) == -1 ? buffer.length - 1 : buffer.indexOf(0x00) - 2;

    const result = buffer.slice(val1, val2).readUInt16BE();
    return result;
  },
  protocol: (buffer: Buffer) => {
    return leb.decode(Array.prototype.slice.call(buffer.slice(0, 2)));
  },
  player: (rawBuffer: Buffer, buffer: Buffer) => {
    if (buffer.indexOf(0x00) == -1) return '';
    const val1 = buffer.indexOf(0x00) + 2;
    const val2 = rawBuffer.length;

    const result = buffer.slice(val1, val2).toString('utf8');

    return result;
  },
  state: (buffer) => {
    const val1 =
      buffer.indexOf(0x00) == -1 ? buffer.length - 1 : buffer.indexOf(0x00) - 2;
    const val2 =
      buffer.indexOf(0x00) == -1 ? buffer.length : buffer.indexOf(0x00) - 1;

    const result = buffer.slice(val1, val2).readInt8();

    return result;
  },
};

export function encode(data: any) {
  data = Buffer.from(JSON.stringify(data), 'utf-8');
  return Buffer.concat([
    leb.encode(data.byteLength + leb.encode(data.byteLength).byteLength + 1),
    Buffer.alloc(1),
    leb.encode(data.byteLength),
    data,
  ]);
}
