import axios from 'axios';
import { PicInfo } from './src/def';

const tags = process.env.IMAGE_TAG || undefined;
const toPage = parseInt(process.env.TO_PAGE) || 10;
const fromPage = parseInt(process.env.FROM_PAGE) || 1;
const baseUrl = process.env.BASE_URL || 'https://konachan.com';
const axiosExtras = JSON.parse(process.env.AXIOS_CONFIG || '{}');

async function main() {
  for (let i = fromPage; i <= toPage; ++i) {
    console.error(`Fetching page ${i}`);
    try {
      const { data } = await axios.get<PicInfo[]>(`${baseUrl}/post.json`, {
        responseType: 'json',
        timeout: 30000,
        params: { tags, page: i },
        ...axiosExtras,
      });
      if (!data?.length) {
        break;
      }
      data.forEach((pic) => console.log(pic.file_url));
    } catch (e) {
      console.error(`Failed to fetch page ${i}: ${e.message}`);
      break;
    }
  }
  console.error(`Finished.`);
}

main();
