import { App, Plugin, Session } from 'koishi';
import koishiPluginOnebot, { BotConfig } from '@koishijs/plugin-adapter-onebot';
import * as koishiPluginVerifier from '@koishijs/plugin-verifier';
import { Adapter } from 'koishi';
import { AdapterConfig } from '@koishijs/plugin-adapter-onebot/lib/utils';
import targetPlugin from './plugin';
import yaml from 'yaml';
import { promises as fs } from 'fs';

type ConfigFromPlugin<P> = P extends Plugin<infer C> ? C : never;

interface Config {
  adapter: Adapter.PluginConfig<AdapterConfig, BotConfig>;
  koishiOptions: App.Config;
  commandPrefix: string;
  adminIds: string[];
  app: any;
}

const defaultConfig: Config = {
  adapter: {
    bots: [
      {
        protocol: 'ws',
        endpoint: process.env.ONEBOT_HOST || 'ws://127.0.0.1:6700',
        selfId: process.env.ONEBOT_ID,
        token: process.env.ONEBOT_TOKEN,
      },
    ],
  },
  koishiOptions: {},
  commandPrefix: process.env.COMMAND_PREFIX || '.',
  adminIds: process.env.ADMIN_ID ? process.env.ADMIN_ID.split(',') : [],
  app: process.env.APP_CONFIG ? JSON.parse(process.env.APP_CONFIG) : undefined,
};

async function main() {
  const config: Config = {
    ...defaultConfig,
    ...yaml.parse(await fs.readFile('./app-config.yaml', 'utf-8')),
  };
  const app = new App({
    prefix: config.commandPrefix,
    ...config.koishiOptions,
  });

  app.plugin(koishiPluginOnebot, config.adapter);

  const adminIds = config.adminIds.map((id) => id.toString());
  app.plugin(koishiPluginVerifier, {
    onFriendRequest: true,
    onGuildRequest: (session: Session) =>
      session.userId && adminIds.includes(session.userId),
  });

  app.plugin(targetPlugin, config.app);

  await app.start();
}
main();
