import { Context } from "koishi-core";
import _ from "lodash";

import "source-map-support/register";

interface Config {
  prefix: string;
}

export const name = "plugin_name";
export function apply(ctx: Context, config: Config = { prefix: "message" }) {
  ctx.command("echo <message:text>").action((argv, message) => {
    return _.join([config.prefix, message], ":");
  });
}
