import 'source-map-support/register';
import { DefineSchema, RegisterSchema } from 'koishi-thirdeye';
import ip from 'ip';

@RegisterSchema()
export class HisoutensokuJammerPluginConfig {
  @DefineSchema({ desc: '干扰时间', default: 10000 })
  attackTimeout: number;

  @DefineSchema({ desc: 'IP 白名单', default: [], type: 'string' })
  addressWhitelist: string[];

  getSubnet(addr: string) {
    return ip.cidrSubnet(addr.includes('/') ? addr : `${addr}/32`);
  }

  isWhitelisted(addr: string) {
    return this.addressWhitelist.some((whitelistAddr) =>
      this.getSubnet(whitelistAddr).contains(addr),
    );
  }
}

export type HisoutensokuJammerPluginConfigLike = Partial<HisoutensokuJammerPluginConfig>;
