import _ from 'lodash';

const chineseCharacterWordList = [
  { character: '０', value: 0 },
  { character: '１', value: 1 },
  { character: '２', value: 2 },
  { character: '３', value: 3 },
  { character: '４', value: 4 },
  { character: '５', value: 5 },
  { character: '６', value: 6 },
  { character: '７', value: 7 },
  { character: '８', value: 8 },
  { character: '９', value: 9 },
  { character: '．', value: '.' },
  { character: '。', value: '.' },
  { character: '⑩', value: 0 },
  { character: '①', value: 1 },
  { character: '②', value: 2 },
  { character: '③', value: 3 },
  { character: '④', value: 4 },
  { character: '⑤', value: 5 },
  { character: '⑥', value: 6 },
  { character: '⑦', value: 7 },
  { character: '⑧', value: 8 },
  { character: '⑨', value: 9 },
  { character: 'zero', value: 0 },
  { character: 'one', value: 1 },
  { character: 'two', value: 2 },
  { character: 'three', value: 3 },
  { character: 'four', value: 4 },
  { character: 'five', value: 5 },
  { character: 'six', value: 6 },
  { character: 'seven', value: 7 },
  { character: 'eight', value: 8 },
  { character: 'nine', value: 9 },
  { character: '⑪', value: 11 },
  { character: '⑫', value: 12 },
  { character: '⑬', value: 13 },
  { character: '⑭', value: 14 },
  { character: '⑮', value: 15 },
  { character: '⑯', value: 16 },
  { character: '⑰', value: 17 },
  { character: '⑱', value: 18 },
  { character: '⑲', value: 19 },
  { character: '⑳', value: 20 },
  { character: 'ling', value: 0 },
  { character: 'yi', value: 1 },
  { character: 'er', value: 2 },
  { character: 'san', value: 3 },
  { character: 'si', value: 4 },
  { character: 'wu', value: 5 },
  { character: 'liu', value: 6 },
  { character: 'qi', value: 7 },
  { character: 'ba', value: 8 },
  { character: 'jiu', value: 9 },
  { character: 'shi', value: 10 },
  { character: '零', value: 0 },
  { character: '〇', value: 0 },
  { character: '洞', value: 0 },
  { character: '一', value: 1 },
  { character: '壹', value: 1 },
  { character: '妖', value: 1 },
  { character: '衣', value: 1 },
  { character: '依', value: 1 },
  { character: '二', value: 2 },
  { character: '贰', value: 2 },
  { character: '两', value: 2 },
  { character: '三', value: 3 },
  { character: '叁', value: 3 },
  { character: '伞', value: 3 },
  { character: '四', value: 4 },
  { character: '肆', value: 4 },
  { character: '五', value: 5 },
  { character: '伍', value: 5 },
  { character: '唔', value: 5 },
  { character: '武', value: 5 },
  { character: '六', value: 6 },
  { character: '陆', value: 6 },
  { character: '溜', value: 6 },
  { character: '七', value: 7 },
  { character: '柒', value: 7 },
  { character: '期', value: 7 },
  { character: '漆', value: 7 },
  { character: '拐', value: 7 },
  { character: '八', value: 8 },
  { character: '捌', value: 8 },
  { character: '怕', value: 8 },
  { character: '把', value: 8 },
  { character: '扒', value: 8 },
  { character: '吧', value: 8 },
  { character: '巴', value: 8 },
  { character: '爸', value: 8 },
  { character: '九', value: 9 },
  { character: '玖', value: 9 },
  { character: '勾', value: 9 },
  { character: '酒', value: 9 },
  { character: '十', value: '' },
  { character: '拾', value: '' },
  { character: '百', value: '' },
  { character: '佰', value: '' },
  { character: '千', value: '' },
  { character: '仟', value: '' },
  { character: '万', value: '' },
].map((l) => ({ character: l.character, value: l.value.toString() }));
const chineseCharacterWordGroup: Record<
  string,
  { character: string; value: string }[]
> = _.groupBy(chineseCharacterWordList, 'value');
export const chineseCharacterList = Object.entries(
  chineseCharacterWordGroup,
).map(([value, patternObjects]) => ({
  value,
  characterRegExp: new RegExp(
    patternObjects.map((patternObject) => patternObject.character).join('|'),
    'g',
  ),
}));
