export function recursiveMatch(
  content: string,
  regex: string | RegExp,
): RegExpMatchArray[] | null {
  const match = content.match(regex);
  if (!match) return null;
  const remainingContent = content.slice(match.index + match[0].length);
  if (!remainingContent) return [match];
  const remainingMatches = recursiveMatch(remainingContent, regex) || [];
  return [match, ...remainingMatches];
}
