import 'source-map-support/register';
import { Bot, Context, Logger, Session } from 'koishi';
import { GuildVerifierConfig, GuildVerifierConfigLike } from './config';
import {
  KoishiPlugin,
  InjectConfig,
  OnPlatform,
  UseEvent,
  OnPrivate,
  UseCommand,
  CommandUsage,
  PutSession,
  PutBot,
  Put,
  PutArg,
  InjectLogger,
} from 'koishi-thirdeye';
export * from './config';

declare module 'koishi' {
  interface Modules {
    myplugin: typeof import('.');
  }
}

@OnPlatform('onebot')
@KoishiPlugin({ name: 'myplugin', schema: GuildVerifierConfig })
export default class GuildVerifier {
  constructor(private ctx: Context, config: GuildVerifierConfigLike) {}

  @InjectConfig()
  private config: GuildVerifierConfig;

  @UseEvent('guild-request')
  private async onGuildRequest(session: Session) {
    if (session.userId && this.config.isAdmin(session.userId)) {
      return session.bot.handleGuildRequest(session.messageId, true);
    }
    if (!this.config.notifyGuildId) {
      return;
    }
    return session.bot.sendMessage(
      this.config.notifyGuildId,
      `${session.username || '未知用户'}(${session.userId}) 邀请我加入群 ${
        session.guildName
      }(${session.guildId}) 。\n请私聊发送我 verify.accept ${
        session.messageId
      } 同意。\n请私聊发送我 verify.reject ${session.messageId} 拒绝。`,
    );
  }

  @OnPrivate()
  @UseCommand('verify', '处理邀请入群请求', { empty: true })
  verifyCommand() {}

  @InjectLogger()
  private logger: Logger;

  async handleRequest(session: Session, messageId: string, accept: boolean) {
    if (!this.config.isAdmin(session.userId)) {
      return '你没有权限操作。';
    }
    try {
      await session.bot.handleGuildRequest(messageId, accept);
    } catch (e) {
      this.logger.error(
        `handleGuildRequest for $${messageId} failed: ${e.toString()}`,
      );
      return `操作失败：${e.toString()}`;
    }
    return `操作成功。`;
  }

  @OnPrivate()
  @UseCommand('verify.accept <messageId:string>', '同意邀请入群请求')
  @CommandUsage('需要具有处理权限。')
  accept(@PutSession() session: Session, @PutArg(0) messageId: string) {
    return this.handleRequest(session, messageId, true);
  }

  @OnPrivate()
  @UseCommand('verify.reject <messageId:string>', '拒绝邀请入群请求')
  @CommandUsage('需要具有处理权限。')
  reject(@PutSession() session: Session, @PutArg(0) messageId: string) {
    return this.handleRequest(session, messageId, false);
  }
}
