// import 'source-map-support/register';
import { DefineSchema, RegisterSchema, SchemaProperty } from 'koishi-thirdeye';

@RegisterSchema()
export class GuildVerifierConfig {
  constructor(config: GuildVerifierConfigLike) {}

  @SchemaProperty({ type: String, description: '管理员 ID。', default: [] })
  adminIds: string[];

  isAdmin(id: string) {
    return this.adminIds.includes(id);
  }

  @SchemaProperty({ description: '通知群组 ID。' })
  notifyGuildId: string;
}

export type GuildVerifierConfigLike = Partial<GuildVerifierConfig>;
