
import fs from "fs";
import util from "util"
import csv_parse_raw from "csv-parse";
import _ from "underscore";
import iconv from "iconv-lite";

const parse_csv: (input: Buffer | string, options?: csv_parse_raw.Options) => Promise<any> = util.promisify(csv_parse_raw);

export async function loadCsv(path: string, columns: boolean, encoding?: string) {
	const buf = await fs.promises.readFile(path);
	const data = iconv.decode(buf, encoding || "GB2312");
	return await parse_csv(data, {
		columns,
		trim: true
		//cast: true
	});
}
export const fileExists: (path: string) => Promise<boolean> = util.promisify(fs.exists);
