import { ApiProperty } from '@nestjs/swagger';
import { HttpException } from '@nestjs/common';

export class BlankReturnMessageDto {
  @ApiProperty({ description: 'Return status code' })
  statusCode: number;
  @ApiProperty({ description: 'Return message' })
  message: string;
  @ApiProperty({ description: 'Whether it succeeded or not' })
  success: boolean;
  constructor(statusCode: number, message?: string) {
    this.statusCode = statusCode;
    this.message = message || 'success';
    this.success = statusCode < 400;
  }

  toException() {
    return new HttpException(this, this.statusCode);
  }
}

export class ReturnMessageDto<T> extends BlankReturnMessageDto {
  @ApiProperty({ description: 'Returning data.' })
  data?: T;
  constructor(statusCode: number, message?: string, data?: T) {
    super(statusCode, message);
    this.data = data;
  }
}

export class StringReturnMessageDto extends BlankReturnMessageDto {
  @ApiProperty({ description: 'The URL should be here.' })
  data: string;
}
