import {
  Controller,
  Post,
  UploadedFile,
  UseInterceptors,
} from '@nestjs/common';
import { AppService } from './app.service';
import { FileInterceptor } from '@nestjs/platform-express';
import * as os from 'os';
import path from 'path';
import { FileUploadDto } from './dto/FileUpload.dto';
import { ApiBody, ApiConsumes, ApiCreatedResponse } from '@nestjs/swagger';
import { StringReturnMessageDto } from './dto/ReturnMessage.dto';
import multer from 'multer';

@Controller()
export class AppController {
  constructor(private readonly appService: AppService) {}

  @Post('upload')
  @ApiConsumes('multipart/form-data')
  @ApiBody({
    description: 'Assets to upload',
    type: FileUploadDto,
  })
  @UseInterceptors(
    FileInterceptor('file', {
      storage: multer.diskStorage({
        destination: path.join(os.tmpdir(), 'uploads'),
      }),
      limits: {
        fileSize: 50 * 1024 * 1024,
        fieldNameSize: 128,
      },
    }),
  )
  @ApiCreatedResponse({ type: StringReturnMessageDto })
  upload(@UploadedFile() file: Express.Multer.File) {
    return this.appService.upload(file);
  }
}
