import { CreateDateColumn, DeleteDateColumn, UpdateDateColumn } from 'typeorm';
import { PageSettingsDto } from '../../dto/PageSettings.dto';
import { NotColumn } from '../decorators/base';

export interface DeletionWise {
  deleteTime?: Date;
}

export class TimeBase extends PageSettingsDto implements DeletionWise {
  @CreateDateColumn({ select: false })
  @NotColumn()
  createTime: Date;

  @UpdateDateColumn({ select: false })
  @NotColumn()
  updateTime: Date;

  @DeleteDateColumn({ select: false })
  @NotColumn()
  deleteTime: Date;

  toObject() {
    return JSON.parse(JSON.stringify(this));
  }
}

export const TimeBaseFields: (keyof TimeBase)[] = [
  'createTime',
  'updateTime',
  'deleteTime',
];
