import { IdNameBase } from './IdNameBase.entity';
import { IdNameDescWise } from '../interfaces/wises';
import { EntityDescription } from '../decorators/extended';
import { SelectQueryBuilder } from 'typeorm';
import { applyQueryPropertySearch } from '../utility/query';

export class IdNameDescBase extends IdNameBase implements IdNameDescWise {
  @EntityDescription()
  desc: string;

  override applyQuery(
    qb: SelectQueryBuilder<IdNameDescBase>,
    entityName: string,
  ) {
    super.applyQuery(qb, entityName);
    applyQueryPropertySearch(this, qb, entityName, 'desc');
  }
}
