import { ValidationPipe } from '@nestjs/common';
import { ClassConstructor, plainToClass } from 'class-transformer';

export const CreatePipe = new ValidationPipe({
  transform: true,
  transformOptions: { groups: ['c'], enableImplicitConversion: true },
});

export const GetPipe = new ValidationPipe({
  transform: true,
  transformOptions: { groups: ['r'], enableImplicitConversion: true },
  skipMissingProperties: true,
  skipNullProperties: true,
  skipUndefinedProperties: true,
});

export class ClassGetPipe<T> extends ValidationPipe {
  constructor(private readonly classConstructor: ClassConstructor<T>) {
    super({
      transform: false,
      transformOptions: {
        groups: ['r'],
        enableImplicitConversion: true,
      },
      skipMissingProperties: true,
      skipNullProperties: true,
      skipUndefinedProperties: true,
    });
  }

  override async transform(value: any, metadata: any) {
    const obj = await super.transform(value, metadata);
    return plainToClass(this.classConstructor, obj, {
      groups: ['r'],
      enableImplicitConversion: false,
    });
  }
}

export const UpdatePipe = new ValidationPipe({
  transform: true,
  transformOptions: { groups: ['u'], enableImplicitConversion: true },
  skipMissingProperties: true,
  skipNullProperties: true,
  skipUndefinedProperties: true,
});
