import { Module } from '@nestjs/common';
import { AppController } from './app.controller';
import { AppService } from './app.service';
import { TypeOrmModule } from '@nestjs/typeorm';
import { ConfigModule, ConfigService } from '@nestjs/config';
import { User } from './entities/User.entity';

const configModule = ConfigModule.forRoot();

@Module({
  imports: [
    configModule,
    TypeOrmModule.forRootAsync({
      name: 'app',
      imports: [configModule],
      inject: [ConfigService],
      useFactory: async (config: ConfigService) => {
        return {
          type: 'postgres',
          entities: [User], // entities here
          synchronize: !config.get('DB_NO_INIT'),
          host: config.get('DB_HOST'),
          port: parseInt(config.get('DB_PORT')) || 5432,
          username: config.get('DB_USER'),
          password: config.get('DB_PASS'),
          database: config.get('DB_NAME'),
        };
      },
    }),
  ],
  controllers: [AppController],
  providers: [AppService],
})
export class AppModule {}
