import { PrimaryColumn, SelectQueryBuilder } from 'typeorm';
import { ApiProperty } from '@nestjs/swagger';
import { StringIdWise } from '../interfaces/wises';
import { applyQueryProperty } from '../utility/query';
import { NotChangeable } from '../decorators/transform';
import { IsNotEmpty, IsString } from 'class-validator';
import { TimeBase } from './TimeBase.entity';

export class ManualIdBase extends TimeBase implements StringIdWise {
  @PrimaryColumn('varchar', { length: 32 })
  @ApiProperty({ description: '编号' })
  @NotChangeable()
  @IsString()
  @IsNotEmpty()
  id: string;

  override applyQuery(
    qb: SelectQueryBuilder<ManualIdBase>,
    entityName: string,
  ) {
    super.applyQuery(qb, entityName);
    qb.orderBy(`${entityName}.id`, 'DESC');
    applyQueryProperty(this, qb, entityName, 'id');
  }
}
