import { TimeBase } from '../bases/TimeBase.entity';
import { SelectQueryBuilder } from 'typeorm';

export function applyQueryProperty<T extends TimeBase>(
  obj: T,
  qb: SelectQueryBuilder<T>,
  entityName: string,
  ...fields: (keyof T)[]
) {
  for (const field of fields) {
    if (obj[field] == null) {
      continue;
    }
    qb.andWhere(`${entityName}.${field} = :${field}`, { [field]: obj[field] });
  }
}
export function applyQueryPropertyLike<T extends TimeBase>(
  obj: T,
  qb: SelectQueryBuilder<T>,
  entityName: string,
  ...fields: (keyof T)[]
) {
  for (const field of fields) {
    if (obj[field] == null) {
      continue;
    }
    qb.andWhere(`${entityName}.${field} like (:${field} || '%')`, {
      [field]: obj[field],
    });
  }
}

export function applyQueryPropertySearch<T extends TimeBase>(
  obj: T,
  qb: SelectQueryBuilder<T>,
  entityName: string,
  ...fields: (keyof T)[]
) {
  for (const field of fields) {
    if (obj[field] == null) {
      continue;
    }
    qb.andWhere(`${entityName}.${field} like ('%' || :${field} || '%')`, {
      [field]: obj[field],
    });
  }
}
