import { CreateDateColumn, UpdateDateColumn } from 'typeorm';
import { Exclude } from 'class-transformer';
import { PageSettingsDto } from '../../dto/PageSettings.dto';

export class TimeBase extends PageSettingsDto {
  @CreateDateColumn({ select: false })
  @Exclude()
  createTime: Date;

  @UpdateDateColumn({ select: false })
  @Exclude()
  updateTime: Date;

  toObject() {
    return JSON.parse(JSON.stringify(this));
  }
}
