import { TimeBase } from './TimeBase.entity';
import { Column, SelectQueryBuilder } from 'typeorm';
import { Exclude } from 'class-transformer';

export interface DeletionWise {
  isDeleted: boolean;
}

export class DeletionBase extends TimeBase implements DeletionWise {
  @Column('boolean', { select: false, default: false })
  @Exclude()
  isDeleted: boolean;

  applyQuery(qb: SelectQueryBuilder<DeletionBase>, entityName: string) {
    super.applyQuery(qb, entityName);
    qb.where(`${entityName}.isDeleted = false`);
  }
}
