import { Module } from '@nestjs/common';
import { AppController } from './app.controller';
import { AppService } from './app.service';
import { ConfigModule } from '@nestjs/config';
import { loadConfig } from './utility/config';

@Module({
  imports: [
    ConfigModule.forRoot({
      ignoreEnvVars: true,
      load: [loadConfig],
    }),
  ],
  controllers: [AppController],
  providers: [AppService],
})
export class AppModule {}
